<?php
require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../config.php';
use App\Controllers\TransactionController;
use App\Controllers\DashboardController;
use App\Controllers\BankController;
use App\Controllers\HistoryController;

use App\Controllers\AuthController;
use App\Controllers\SettingsController;

// Simple Auth Middleware
if (session_status() === PHP_SESSION_NONE)
    session_start();
$page = $_GET['page'] ?? 'dashboard';

// Public pages
$publicPages = ['login'];

if (!isset($_SESSION['user_id']) && !in_array($page, $publicPages)) {
    header('Location: index.php?page=login');
    exit;
}

switch ($page) {
    case 'login':
        (new AuthController($pdo))->login();
        break;
    case 'logout':
        (new AuthController($pdo))->logout();
        break;
    case 'dashboard':
        (new DashboardController($pdo))->index();
        break;

    case 'history':
        (new HistoryController($pdo))->index();
        break;
    case 'transactions/create':
        (new TransactionController($pdo))->handleRequest();
        break;
    case 'settings':
        (new SettingsController($pdo))->index();
        break;
    case 'settings/export':
        (new SettingsController($pdo))->export();
        break;
    case 'settings/import':
        (new SettingsController($pdo))->import();
        break;
    case 'settings/reset':
        (new SettingsController($pdo))->reset();
        break;

    // Categories
    case 'settings/categories':
        (new App\Controllers\CategoryController($pdo))->index();
        break;
    case 'settings/categories/create':
        (new App\Controllers\CategoryController($pdo))->create();
        break;
    case 'settings/categories/delete':
        (new App\Controllers\CategoryController($pdo))->delete();
        break;

    // PPOB Routes
    case 'ppob/menu':
        (new App\Controllers\PPOBController($pdo))->menu();
        break;
    case 'ppob/service':
        $cat = $_GET['category'] ?? 'PULSA';
        (new App\Controllers\PPOBController($pdo))->service($cat);
        break;
    case 'ppob/checkout':
        (new App\Controllers\PPOBController($pdo))->checkout();
        break;
    case 'receipt':
        include __DIR__ . '/../views/receipt.php';
        break;

    // Service Management (Admin)
    case 'admin/services':
        (new App\Controllers\AdminServiceController($pdo))->index();
        break;
    case 'admin/services/create':
        (new App\Controllers\AdminServiceController($pdo))->create();
        break;
    case 'admin/services/delete':
        (new App\Controllers\AdminServiceController($pdo))->delete();
        break;
    case 'admin/services/edit':
        (new App\Controllers\AdminServiceController($pdo))->edit();
        break;

    // Audit Logs
    case 'admin/audit':
        (new App\Controllers\AuditController($pdo))->index();
        break;

    // API Integrations (Settings)
    case 'settings/integrations':
        (new App\Controllers\IntegrationController($pdo))->index();
        break;
    case 'settings/integrations/update':
        (new App\Controllers\IntegrationController($pdo))->update();
        break;

    // User Profile
    case 'profile':
        (new App\Controllers\ProfileController($pdo))->index();
        break;
    case 'profile/update':
        (new App\Controllers\ProfileController($pdo))->update();
        break;

    // Analytics
    case 'analytics':
        (new App\Controllers\AnalyticsController($pdo))->index();
        break;

    // User Management (Admin)
    case 'admin/users':
        (new App\Controllers\AdminUserController($pdo))->index();
        break;
    case 'admin/users/create':
        (new App\Controllers\AdminUserController($pdo))->create();
        break;
    case 'admin/users/topup':
        (new App\Controllers\AdminUserController($pdo))->topup();
        break;

    // Bank Management
    case 'banks':
        (new BankController($pdo))->index();
        break;
    case 'banks/create':
        (new BankController($pdo))->create();
        break;
    case 'banks/edit':
        (new BankController($pdo))->edit();
        break;
    case 'banks/show':
        (new BankController($pdo))->show();
        break;
    case 'banks/import':
        (new BankController($pdo))->import();
        break;

    // Banking Operations
    case 'banking':
        (new App\Controllers\AccountController($pdo))->index();
        break;
    case 'banking/transfer':
        (new App\Controllers\AccountController($pdo))->transfer();
        break;
    case 'banking/deposit':
        (new App\Controllers\AccountController($pdo))->deposit();
        break;
    case 'banking/withdraw':
        (new App\Controllers\AccountController($pdo))->withdraw();
        break;

    default:
        // Fallback to dashboard
        (new DashboardController($pdo))->index();
        break;
}
?>