<?php
namespace App\Controllers;

use PDO;

class AdminServiceController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        $stmt = $this->pdo->query("SELECT * FROM services ORDER BY category, name ASC");
        $services = $stmt->fetchAll(PDO::FETCH_ASSOC);
        include __DIR__ . '/../../views/admin/services/index.php';
    }

    public function edit(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['id'];
            $price = $_POST['base_price'];
            $fee = $_POST['admin_fee'];
            $commission = $_POST['agent_commission'];
            $active = isset($_POST['is_active']) ? 1 : 0;

            $stmt = $this->pdo->prepare("
                UPDATE services 
                SET base_price = :price, admin_fee = :fee, agent_commission = :comm, is_active = :active
                WHERE id = :id
            ");
            $stmt->execute([
                ':price' => $price,
                ':fee' => $fee,
                ':comm' => $commission,
                ':active' => $active,
                ':id' => $id
            ]);

            header("Location: index.php?page=admin/services&success=updated");
            exit;
        }
    }
    public function create(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $code = $_POST['code'];
            $name = $_POST['name'];
            $category = $_POST['category'];
            $price = $_POST['price'];
            $fee = $_POST['fee'];
            $commission = $_POST['commission'];
            $status = 1; // Active by default

            $stmt = $this->pdo->prepare("INSERT INTO services (code, name, category, base_price, admin_fee, agent_commission, is_active) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$code, $name, $category, $price, $fee, $commission, $status]);

            // Audit Log
            $this->logAudit('create_service', "Created service: $name ($code)");

            header('Location: index.php?page=admin/services&success=created');
            exit;
        }
    }

    public function delete(): void
    {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];

            // Get name for log
            $stmt = $this->pdo->prepare("SELECT name FROM services WHERE id = ?");
            $stmt->execute([$id]);
            $service = $stmt->fetch();
            $name = $service['name'] ?? 'Unknown';

            $stmt = $this->pdo->prepare("DELETE FROM services WHERE id = ?");
            $stmt->execute([$id]);

            // Audit Log
            $this->logAudit('delete_service', "Deleted service: $name");

            header('Location: index.php?page=admin/services&success=deleted');
            exit;
        }
    }

    private function logAudit($action, $description): void
    {
        if (isset($_SESSION['user_id'])) {
            $stmt = $this->pdo->prepare("INSERT INTO audit_logs (user_id, action, description, ip_address) VALUES (?, ?, ?, ?)");
            $stmt->execute([$_SESSION['user_id'], $action, $description, $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1']);
        }
    }
}