<?php
namespace App\Controllers;

use PDO;

class AdminUserController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        $stmt = $this->pdo->query("SELECT * FROM users ORDER BY created_at DESC");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        include __DIR__ . '/../../views/admin/users/index.php';
    }

    public function create(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'];
            $fullname = $_POST['full_name'];
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $pin = password_hash($_POST['pin'], PASSWORD_DEFAULT);
            $role = $_POST['role'];
            $balance = 0;

            $stmt = $this->pdo->prepare("INSERT INTO users (username, full_name, password_hash, pin_hash, role, balance) VALUES (?, ?, ?, ?, ?, ?)");
            try {
                $stmt->execute([$username, $fullname, $password, $pin, $role, $balance]);
                header('Location: index.php?page=admin/users&success=created');
                exit;
            } catch (\PDOException $e) {
                die("Error: Username mungkin sudah ada.");
            }
        }
    }

    public function topup(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['user_id'];
            $amount = $_POST['amount'];

            // In a real accounting system, this money needs to come from somewhere (e.g. Master Cash Account)
            // For this app size, we just inject money.

            try {
                $this->pdo->beginTransaction();

                $stmt = $this->pdo->prepare("UPDATE users SET balance = balance + :amt WHERE id = :id");
                $stmt->execute([':amt' => $amount, ':id' => $id]);

                // Log as 'credit' transaction for that user
                $stmt = $this->pdo->prepare("
                    INSERT INTO transactions (
                        user_id, amount, transaction_type, description, transaction_date, status
                    ) VALUES (
                        :uid, :amt, 'credit', 'Topup Saldo oleh Admin', NOW(), 'SUCCESS'
                    )
                ");
                $stmt->execute([':uid' => $id, ':amt' => $amount]);

                $this->pdo->commit();
                header('Location: index.php?page=admin/users&success=topup');
                exit;
            } catch (\Exception $e) {
                $this->pdo->rollBack();
                die($e->getMessage());
            }
        }
    }
}
?>