<?php
namespace App\Controllers;

use PDO;

class AuditController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        // Only Admin or Owner
        if (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'owner')) {
            header('Location: index.php?page=dashboard');
            exit;
        }

        $sql = "
            SELECT a.*, u.username, u.full_name 
            FROM audit_logs a 
            LEFT JOIN users u ON a.user_id = u.id 
            ORDER BY a.created_at DESC 
            LIMIT 100
        ";
        $stmt = $this->pdo->query($sql);
        $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

        include __DIR__ . '/../../views/admin/audit/index.php';
    }
}
