<?php
namespace App\Controllers;

use PDO;

class CategoryController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        $stmt = $this->pdo->query("SELECT * FROM categories ORDER BY name ASC");
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
        include __DIR__ . '/../../views/settings/categories.php';
    }

    public function create(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $name = trim($_POST['name']);
            if (!empty($name)) {
                $stmt = $this->pdo->prepare("INSERT INTO categories (name) VALUES (:name)");
                try {
                    $stmt->execute([':name' => $name]);
                    header('Location: index.php?page=settings/categories&success=created');
                    exit;
                } catch (\PDOException $e) {
                    // Handle duplicate or error
                    header('Location: index.php?page=settings/categories&error=exists');
                    exit;
                }
            }
        }
    }

    public function delete(): void
    {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];

            // Soft check for usage
            $check = $this->pdo->prepare("SELECT COUNT(*) FROM transactions WHERE category_id = :id");
            $check->execute([':id' => $id]);
            if ($check->fetchColumn() > 0) {
                header('Location: index.php?page=settings/categories&error=in_use');
                exit;
            }

            $stmt = $this->pdo->prepare("DELETE FROM categories WHERE id = :id");
            $stmt->execute([':id' => $id]);
            header('Location: index.php?page=settings/categories&success=deleted');
            exit;
        }
    }
}
?>