<?php
namespace App\Controllers;

use PDO;

class HistoryController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        $tab = $_GET['tab'] ?? 'bank';

        $sql = "
            SELECT t.*, c.name as category_name, s.category as service_category, s.name as service_name, 
                   u.full_name as executor_name, a.account_number, b.name as bank_name
            FROM transactions t
            LEFT JOIN categories c ON t.category_id = c.id
            LEFT JOIN services s ON t.service_id = s.id
            LEFT JOIN users u ON t.user_id = u.id
            LEFT JOIN accounts a ON t.account_id = a.id
            LEFT JOIN banks b ON a.bank_id = b.id
            WHERE 1=1
        ";

        $params = [];

        // Tab Logic
        if ($tab === 'bank') {
            // Manual entries (service_id IS NULL) OR E-Wallet (service_category = 'ewallet')
            $sql .= " AND (t.service_id IS NULL OR s.category = 'ewallet')";
        } else {
            // PPOB entries (service_id NOT NULL) AND NOT E-Wallet
            $sql .= " AND (t.service_id IS NOT NULL AND (s.category != 'ewallet' OR s.category IS NULL))";
        }

        // Date Range Filter
        if (!empty($_GET['start_date']) && !empty($_GET['end_date'])) {
            $sql .= " AND DATE(t.transaction_date) BETWEEN :start AND :end";
            $params[':start'] = $_GET['start_date'];
            $params[':end'] = $_GET['end_date'];
        }

        // Bank Filter
        if (!empty($_GET['bank_id'])) {
            $sql .= " AND a.bank_id = :bank_id";
            $params[':bank_id'] = $_GET['bank_id'];
        }

        // Executor/User Filter
        if (!empty($_GET['user_id'])) {
            $sql .= " AND t.user_id = :user_id";
            $params[':user_id'] = $_GET['user_id'];
        }

        // Service/Product Filter
        if (!empty($_GET['service_id'])) {
            $sql .= " AND t.service_id = :service_id";
            $params[':service_id'] = $_GET['service_id'];
        }

        // Transaction Type Filter (credit/debit)
        if (!empty($_GET['transaction_type'])) {
            $sql .= " AND t.transaction_type = :transaction_type";
            $params[':transaction_type'] = $_GET['transaction_type'];
        }

        // Status Filter
        if (!empty($_GET['status'])) {
            $sql .= " AND t.status = :status";
            $params[':status'] = $_GET['status'];
        }

        // Category Filter
        if (!empty($_GET['category_id'])) {
            $sql .= " AND t.category_id = :category_id";
            $params[':category_id'] = $_GET['category_id'];
        }

        $sql .= " ORDER BY t.transaction_date DESC";

        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Get filter options
        $banks = $this->pdo->query("SELECT id, name FROM banks ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
        $users = $this->pdo->query("SELECT id, full_name FROM users ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
        $services = $this->pdo->query("SELECT id, name, category FROM services ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
        $categories = $this->pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

        include __DIR__ . '/../../views/history.php';
    }
}
?>