<?php
namespace App\Controllers;

use PDO;

class IntegrationController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        // Fetch all settings
        $stmt = $this->pdo->query("SELECT * FROM settings");
        $settingsRaw = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $settings = [];
        foreach ($settingsRaw as $s) {
            $settings[$s['key_name']] = $s['value'];
        }

        include __DIR__ . '/../../views/settings/integrations.php';
    }

    public function update(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            foreach ($_POST as $key => $value) {
                // Ensure key exists in DB (security check could be added here)
                $stmt = $this->pdo->prepare("UPDATE settings SET value = ? WHERE key_name = ?");
                $stmt->execute([$value, $key]);
            }

            // Log this action if possible
            if (isset($_SESSION['user_id'])) {
                $stmt = $this->pdo->prepare("INSERT INTO audit_logs (user_id, action, description, ip_address) VALUES (?, 'update_settings', 'Updated API Integrations', ?)");
                $stmt->execute([$_SESSION['user_id'], $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1']);
            }

            header('Location: index.php?page=settings/integrations&success=updated');
            exit;
        }
    }
}
