<?php
namespace App\Controllers;

use PDO;

class PPOBController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function menu(): void
    {
        $stmt = $this->pdo->query("SELECT category, COUNT(*) as count FROM services WHERE is_active = 1 GROUP BY category");
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
        include __DIR__ . '/../../views/ppob/menu.php';
    }

    public function service(string $category): void
    {
        $stmt = $this->pdo->prepare("SELECT * FROM services WHERE category = :cat AND is_active = 1");
        $stmt->execute([':cat' => strtoupper($category)]);
        $services = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // If empty, maybe redirect or show error
        if (!$services) {
            header('Location: index.php?page=ppob/menu');
            exit;
        }

        include __DIR__ . '/../../views/ppob/service_form.php';
    }

    public function checkout(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $serviceId = $_POST['service_id'];
            $customerPhone = $_POST['customer_phone'];
            $pin = $_POST['pin'];
            $userId = $_SESSION['user_id'];

            // 1. Verify PIN
            $stmt = $this->pdo->prepare("SELECT pin_hash, balance FROM users WHERE id = :id");
            $stmt->execute([':id' => $userId]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$user || !password_verify($pin, $user['pin_hash'])) { // Using password_verify for PIN hash check
                $error = "PIN Salah!";
                // In real app, redirect back with error. For MVP, die().
                die($error);
            }

            // 2. Get Service Info
            $stmt = $this->pdo->prepare("SELECT * FROM services WHERE id = :id");
            $stmt->execute([':id' => $serviceId]);
            $service = $stmt->fetch(PDO::FETCH_ASSOC);

            $totalCost = $service['base_price']; // Cost to agent
            // Customer pays: base_price + admin_fee
            // Agent Profit: agent_commission

            // 3. Check Balance
            if ($user['balance'] < $totalCost) {
                die("Saldo tidak mencukupi!");
            }

            // 4. Record Transaction
            try {
                $this->pdo->beginTransaction();

                // Deduct Balance
                $stmt = $this->pdo->prepare("UPDATE users SET balance = balance - :amount WHERE id = :id");
                $stmt->execute([':amount' => $totalCost, ':id' => $userId]);

                // Insert Transaction
                $stmt = $this->pdo->prepare("
                    INSERT INTO transactions (
                        user_id, account_id, service_id, amount, transaction_type, 
                        description, transaction_date, customer_phone, fee_amount, profit_amount, status
                    ) VALUES (
                        :uid, NULL, :sid, :amt, 'debit', :desc, NOW(), :phone, :fee, :profit, 'SUCCESS'
                    )
                ");
                $stmt->execute([
                    ':uid' => $userId,
                    ':sid' => $serviceId,
                    ':amt' => $totalCost, // Amount deducted from agent
                    ':desc' => "Pembelian " . $service['name'] . " - " . $customerPhone,
                    ':phone' => $customerPhone,
                    ':fee' => $service['admin_fee'],
                    ':profit' => $service['agent_commission']
                ]);

                $trxId = $this->pdo->lastInsertId();

                $this->pdo->commit();

                header("Location: index.php?page=receipt&id=$trxId");
                exit;

            } catch (\Exception $e) {
                $this->pdo->rollBack();
                die("Transaksi Gagal: " . $e->getMessage());
            }
        }
    }
}
?>