<?php
namespace App\Controllers;

use PDO;

class ProfileController
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function index(): void
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: index.php?page=login');
            exit;
        }

        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE id = :id");
        $stmt->execute([':id' => $_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            session_destroy();
            header('Location: index.php?page=login');
            exit;
        }

        include __DIR__ . '/../../views/profile/index.php';
    }

    public function update(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SESSION['user_id'])) {
            $userId = $_SESSION['user_id'];
            $newPassword = $_POST['password'] ?? '';
            $newPin = $_POST['pin'] ?? '';

            // Validate (Simple validation for MVP)
            if (!empty($newPassword)) {
                $hash = password_hash($newPassword, PASSWORD_DEFAULT);
                $stmt = $this->pdo->prepare("UPDATE users SET password_hash = :p WHERE id = :id");
                $stmt->execute([':p' => $hash, ':id' => $userId]);
                $this->logAudit('update_profile', "User changed password");
            }

            if (!empty($newPin)) {
                $stmt = $this->pdo->prepare("UPDATE users SET pin_hash = :p WHERE id = :id");
                $stmt->execute([':p' => $newPin, ':id' => $userId]);
                $this->logAudit('update_profile', "User changed PIN");
            }

            header('Location: index.php?page=profile&success=updated');
            exit;
        }
    }

    private function logAudit($action, $description): void
    {
        if (isset($_SESSION['user_id'])) {
            $stmt = $this->pdo->prepare("INSERT INTO audit_logs (user_id, action, description, ip_address) VALUES (?, ?, ?, ?)");
            $stmt->execute([$_SESSION['user_id'], $action, $description, $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1']);
        }
    }
}
