<?php
namespace App\Controllers;

use PDO;

class TransactionController
{
    private PDO $pdo;
    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }
    public function handleRequest(): void
    {
        $method = $_SERVER['REQUEST_METHOD'];
        if ($method === 'POST') {
            $this->createTransaction();
        } else {
            $this->showForm();
        }
    }
    private function createTransaction(): void
    {
        $data = $_POST;

        // Begin transaction for data integrity
        $this->pdo->beginTransaction();

        try {
            // Insert transaction
            $stmt = $this->pdo->prepare(
                "INSERT INTO transactions (account_id, amount, transaction_type, description, transaction_date, external_ref, category_id, status, user_id) 
                 VALUES (:account_id, :amount, :type, :desc, :date, :ref, :cat, 'success', :user_id)"
            );
            $stmt->execute([
                ':account_id' => $data['account_id'],
                ':amount' => $data['amount'],
                ':type' => $data['type'],
                ':desc' => $data['description'] ?? null,
                ':date' => $data['transaction_date'],
                ':ref' => $data['external_ref'] ?? null,
                ':cat' => !empty($data['category_id']) ? $data['category_id'] : null,
                ':user_id' => $_SESSION['user_id']
            ]);

            // Update account balance
            $balanceChange = ($data['type'] === 'credit') ? $data['amount'] : -$data['amount'];
            $stmt = $this->pdo->prepare("UPDATE accounts SET balance = balance + ? WHERE id = ?");
            $stmt->execute([$balanceChange, $data['account_id']]);

            $this->pdo->commit();
            header('Location: index.php?page=dashboard&success=1');
            exit;

        } catch (\Exception $e) {
            $this->pdo->rollBack();
            header('Location: index.php?page=transactions/create&error=1');
            exit;
        }
    }

    private function showForm(): void
    {
        $banks = $this->pdo->query('SELECT * FROM banks')->fetchAll(PDO::FETCH_ASSOC);
        $accounts = $this->pdo->query('SELECT a.*, b.name AS bank_name FROM accounts a JOIN banks b ON a.bank_id = b.id')->fetchAll(PDO::FETCH_ASSOC);
        $categories = $this->pdo->query('SELECT * FROM categories ORDER BY name ASC')->fetchAll(PDO::FETCH_ASSOC);
        include __DIR__ . '/../../views/transaction_form.php';
    }
}
?>