<?php
namespace App\Services;

use PDO;

class BankApi
{
    /**
     * Mock implementation that logs the transaction to bank_api_logs table.
     * In a real scenario this would call the bank's API endpoint.
     */
    public static function pushTransaction(PDO $pdo, array $bank, array $transaction): bool
    {
        $stmt = $pdo->prepare(
            "INSERT INTO bank_api_logs (bank_id, request_payload, response_payload, status_code) VALUES (:bank_id, :req, :res, :code)"
        );
        $stmt->execute([
            ':bank_id' => $bank['id'],
            ':req' => json_encode($transaction),
            ':res' => json_encode(['status' => 'queued']),
            ':code' => 202,
        ]);
        return true;
    }
}
?>