<?php
require __DIR__ . '/config.php';
require __DIR__ . '/src/Services/BankApi.php';

use App\Services\BankApi;

// Ensure PDO throws exceptions
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Fetch unsynced transactions
$stmt = $pdo->query(
    "SELECT t.*, a.bank_id FROM transactions t JOIN accounts a ON t.account_id = a.id WHERE t.synced_at IS NULL"
);

while ($tx = $stmt->fetch(PDO::FETCH_ASSOC)) {
    // Get bank details
    $bank = $pdo->query('SELECT * FROM banks WHERE id=' . $tx['bank_id'])->fetch(PDO::FETCH_ASSOC);
    if ($bank && BankApi::pushTransaction($pdo, $bank, $tx)) {
        $update = $pdo->prepare('UPDATE transactions SET synced_at = NOW() WHERE id = :id');
        $update->execute([':id' => $tx['id']]);
    }
}
?>