<?php
$pageTitle = 'Audit Logs';
include __DIR__ . '/../../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
    <div style="margin-bottom:1.5rem;">
        <h2 style="margin:0;">Jejak Audit Sistem</h2>
        <p style="color:#6b7280; font-size:0.9rem; margin-top:0.25rem;">Mencatat 100 aktivitas terakhir pengguna.</p>
    </div>

    <div style="overflow-x:auto;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="border-bottom: 2px solid #f3f4f6; text-align:left;">
                    <th style="padding:1rem; width:150px;">Waktu</th>
                    <th style="padding:1rem;">User</th>
                    <th style="padding:1rem;">Aksi</th>
                    <th style="padding:1rem;">Deskripsi</th>
                    <th style="padding:1rem;">IP Address</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($logs)): ?>
                    <tr>
                        <td colspan="5" style="padding: 3rem; text-align: center; color: #9ca3af;">
                            <div style="font-size: 2rem; margin-bottom: 0.5rem;">📋</div>
                            <div style="font-weight: 500; margin-bottom: 0.25rem;">Belum ada jejak audit</div>
                            <div style="font-size: 0.85rem;">Aktivitas sistem akan tercatat di sini</div>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($logs as $log): ?>
                        <tr style="border-bottom: 1px solid #f3f4f6;">
                            <td style="padding:1rem;">
                                <div style="font-size: 0.85rem; font-weight: 500; color: #111827;">
                                    <?= date('d M Y', strtotime($log['created_at'])) ?>
                                </div>
                                <div style="font-size: 0.75rem; color: #6b7280;">
                                    <?= date('H:i:s', strtotime($log['created_at'])) ?> WIB
                                </div>
                            </td>
                            <td style="padding:1rem; font-weight:600;">
                                <?= htmlspecialchars($log['full_name'] ?? $log['username'] ?? 'System') ?></td>
                            <td style="padding:1rem;">
                                <span
                                    style="background:#eff6ff; color:#1d4ed8; padding:0.2rem 0.5rem; border-radius:4px; font-size:0.75rem; text-transform:uppercase;">
                                    <?= htmlspecialchars($log['action']) ?>
                                </span>
                            </td>
                            <td style="padding:1rem; color:#374151;"><?= htmlspecialchars($log['description']) ?></td>
                            <td style="padding:1rem; font-family:monospace; font-size:0.85rem; color:#9ca3af;">
                                <?= htmlspecialchars($log['ip_address']) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>