<?php
$pageTitle = 'Kelola Layanan PPOB';
include __DIR__ . '/../../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
    <div class="header-actions"
        style="display:flex; justify-content:space-between; align-items:center; margin-bottom:1.5rem;">
        <div>
            <h2 style="margin:0;">Manajemen Produk & Fee</h2>
            <p style="color:#6b7280; font-size:0.9rem; margin-top:0.25rem;">Atur harga jual dan keuntungan layanan.</p>
        </div>
        <button onclick="document.getElementById('addServiceModal').style.display='flex'"
            style="background:#4f46e5; color:white; border:none; padding:0.75rem 1.5rem; border-radius:8px; cursor:pointer;">
            + Tambah Layanan
        </button>
    </div>

    <!-- Add Service Modal -->
    <div id="addServiceModal"
        style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); justify-content:center; align-items:center; z-index:1000;">
        <div style="background:white; padding:2rem; border-radius:12px; width:400px; max-width:90%;">
            <div style="display:flex; justify-content:space-between; margin-bottom:1rem;">
                <h3 style="margin:0;">Tambah Layanan</h3>
                <button onclick="document.getElementById('addServiceModal').style.display='none'"
                    style="background:none; border:none; font-size:1.5rem; cursor:pointer;">&times;</button>
            </div>
            <form method="POST" action="index.php?page=admin/services/create">
                <input type="text" name="code" placeholder="Kode (Misal: PLS10)" required
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                <input type="text" name="name" placeholder="Nama Layanan" required
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                <select name="category" required
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                    <option value="pulsa">Pulsa</option>
                    <option value="data">Data</option>
                    <option value="pln">PLN</option>
                    <option value="ewallet">E-Wallet</option>
                    <option value="pdam">PDAM</option>
                </select>
                <input type="number" name="price" placeholder="Harga Dasar (Modal)" required
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                <input type="number" name="fee" placeholder="Biaya Admin" value="0"
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                <input type="number" name="commission" placeholder="Komisi / Profit" value="0"
                    style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
                <button type="submit"
                    style="width:100%; background:#4f46e5; color:white; border:none; padding:0.75rem; border-radius:8px; font-weight:600; cursor:pointer;">Simpan</button>
            </form>
        </div>
    </div>

    <div style="overflow-x:auto;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="border-bottom: 2px solid #f3f4f6; text-align:left;">
                    <th style="padding:1rem;">Kode</th>
                    <th style="padding:1rem;">Layanan</th>
                    <th style="padding:1rem;">Kategori</th>
                    <th style="padding:1rem;">Harga Dasar</th>
                    <th style="padding:1rem;">Biaya Admin</th>
                    <th style="padding:1rem;">Profit</th>
                    <th style="padding:1rem;">Total Jual</th>
                    <th style="padding:1rem;">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($services as $s): ?>
                    <tr style="border-bottom: 1px solid #f3f4f6;">
                        <td style="padding:1rem; font-family:monospace; font-weight:600;">
                            <?= htmlspecialchars($s['code']) ?>
                        </td>
                        <td style="padding:1rem; font-weight:500;"><?= htmlspecialchars($s['name']) ?></td>
                        <td style="padding:1rem;">
                            <span
                                style="background:#f3f4f6; padding:0.2rem 0.6rem; border-radius:6px; font-size:0.8rem; text-transform:uppercase;">
                                <?= htmlspecialchars($s['category']) ?>
                            </span>
                        </td>
                        <td style="padding:1rem;">Rp <?= number_format($s['base_price'], 0) ?></td>
                        <td style="padding:1rem;">Rp <?= number_format($s['admin_fee'], 0) ?></td>
                        <td style="padding:1rem; color:#10b981; font-weight:600;">Rp
                            <?= number_format($s['agent_commission'], 0) ?>
                        </td>
                        <td style="padding:1rem; font-weight:600;">Rp
                            <?= number_format($s['base_price'] + $s['admin_fee'], 0) ?>
                        </td>
                        <td style="padding:1rem; display:flex; gap:0.5rem;">
                            <button onclick="editService(<?= htmlspecialchars(json_encode($s)) ?>)"
                                style="background:#e0e7ff; color:#4338ca; border:none; padding:0.3rem 0.6rem; border-radius:6px; cursor:pointer; font-size:0.8rem;">
                                Edit
                            </button>
                            <a href="index.php?page=admin/services/delete&id=<?= $s['id'] ?>"
                                onclick="return confirm('Hapus layanan <?= $s['name'] ?>?')"
                                style="background:#fee2e2; color:#ef4444; border:none; padding:0.3rem 0.6rem; border-radius:6px; text-decoration:none; font-size:0.8rem;">
                                Hapus
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Edit Service Modal -->
<div id="editServiceModal"
    style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); justify-content:center; align-items:center; z-index:1000;">
    <div style="background:white; padding:2rem; border-radius:12px; width:400px; max-width:90%;">
        <div style="display:flex; justify-content:space-between; margin-bottom:1rem;">
            <h3 style="margin:0;">Edit Layanan</h3>
            <button onclick="document.getElementById('editServiceModal').style.display='none'"
                style="background:none; border:none; font-size:1.5rem; cursor:pointer;">&times;</button>
        </div>
        <form method="POST" action="index.php?page=admin/services/edit" id="editForm">
            <input type="hidden" name="id" id="edit_id">

            <label style="display:block; margin-bottom:0.5rem; font-size:0.9rem; font-weight:500;">Harga Dasar</label>
            <input type="number" name="base_price" id="edit_price" required
                style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">

            <label style="display:block; margin-bottom:0.5rem; font-size:0.9rem; font-weight:500;">Biaya Admin</label>
            <input type="number" name="admin_fee" id="edit_fee"
                style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">

            <label style="display:block; margin-bottom:0.5rem; font-size:0.9rem; font-weight:500;">Komisi Agen</label>
            <input type="number" name="agent_commission" id="edit_commission"
                style="width:100%; margin-bottom:1rem; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">

            <label style="display:flex; align-items:center; gap:0.5rem; margin-bottom:1.5rem;">
                <input type="checkbox" name="is_active" id="edit_active" value="1"> Aktif
            </label>

            <button type="submit"
                style="width:100%; background:#4f46e5; color:white; border:none; padding:0.75rem; border-radius:8px; font-weight:600; cursor:pointer;">Simpan
                Perubahan</button>
        </form>
    </div>
</div>

<script>
    function editService(service) {
        document.getElementById('edit_id').value = service.id;
        document.getElementById('edit_price').value = service.base_price;
        document.getElementById('edit_fee').value = service.admin_fee;
        document.getElementById('edit_commission').value = service.agent_commission;
        document.getElementById('edit_active').checked = service.is_active == 1;
        document.getElementById('editServiceModal').style.display = 'flex';
    }
</script>
</div>

<style>
    @media (max-width: 600px) {
        .card {
            padding: 1.5rem !important;
        }

        .header-actions {
            flex-direction: column;
            align-items: flex-start !important;
            gap: 1rem;
        }

        .header-actions button {
            width: 100%;
        }

        /* Modal tweaks */
        #addServiceModal>div {
            width: 95% !important;
            padding: 1.5rem !important;
        }
    }
</style>

<?php include __DIR__ . '/../../layout/footer.php'; ?>