<?php
$pageTitle = 'Kelola Agen & Pengguna';
include __DIR__ . '/../../layout/header.php';
?>

<div class="user-management-grid" style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">

    <!-- User List -->
    <div class="card"
        style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h2 style="margin-top:0;">Daftar Agen</h2>
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; min-width: 600px;">
                <thead>
                    <tr style="border-bottom: 2px solid #f3f4f6; text-align:left;">
                        <th style="padding:1rem;">Username</th>
                        <th style="padding:1rem;">Nama Lengkap</th>
                        <th style="padding:1rem;">Saldo</th>
                        <th style="padding:1rem;">Role</th>
                        <th style="padding:1rem;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $u): ?>
                        <tr style="border-bottom: 1px solid #f3f4f6;">
                            <td style="padding:1rem; font-weight:500;"><?= htmlspecialchars($u['username']) ?></td>
                            <td style="padding:1rem;"><?= htmlspecialchars($u['full_name']) ?></td>
                            <td style="padding:1rem; font-weight:600; color:#059669;">Rp
                                <?= number_format($u['balance'], 0) ?>
                            </td>
                            <td style="padding:1rem;">
                                <?php
                                $roleColors = [
                                    'owner' => ['bg' => '#f3e8ff', 'text' => '#7e22ce'], // Purple
                                    'admin' => ['bg' => '#fee2e2', 'text' => '#ef4444'], // Red
                                    'agent' => ['bg' => '#e0e7ff', 'text' => '#4f46e5'], // Blue
                                ];
                                $rcl = $roleColors[$u['role']] ?? $roleColors['agent'];
                                ?>
                                <span
                                    style="background:<?= $rcl['bg'] ?>; color:<?= $rcl['text'] ?>; padding:0.2rem 0.6rem; border-radius:99px; font-size:0.8rem;">
                                    <?= strtoupper($u['role']) ?>
                                </span>
                            </td>
                            <td style="padding:1rem;">
                                <!-- Topup Modal Trigger (Simplified as prompt for MVP) -->
                                <?php if ($u['role'] != 'admin' && $u['role'] != 'owner'): ?>
                                    <form method="POST" action="index.php?page=admin/users/topup" style="display:inline;"
                                        onsubmit="return confirm('Topup saldo untuk <?= $u['username'] ?>?');">
                                        <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                                        <input type="number" name="amount" placeholder="Nominal"
                                            style="width:100px; padding:0.3rem; border:1px solid #d1d5db; border-radius:6px;"
                                            required>
                                        <button type="submit"
                                            style="background:#10b981; color:white; border:none; padding:0.3rem 0.6rem; border-radius:6px; cursor:pointer;">Topup</button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Create User Form -->
    <div class="card"
        style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); height: fit-content;">
        <h2 style="margin-top:0;">Tambah Agen Baru</h2>
        <form method="POST" action="index.php?page=admin/users/create">
            <div style="margin-bottom: 1rem;">
                <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Username</label>
                <input type="text" name="username" required
                    style="width:100%; padding:0.7rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div style="margin-bottom: 1rem;">
                <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Nama Lengkap</label>
                <input type="text" name="full_name" required
                    style="width:100%; padding:0.7rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div style="margin-bottom: 1rem;">
                <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Password Login</label>
                <input type="password" name="password" required
                    style="width:100%; padding:0.7rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div style="margin-bottom: 1.5rem;">
                <label style="display:block; margin-bottom:0.5rem; font-weight:500;">PIN Transaksi</label>
                <input type="password" name="pin" required maxlength="6"
                    style="width:100%; padding:0.7rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div style="margin-bottom: 1.5rem;">
                <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Role</label>
                <select name="role" style="width:100%; padding:0.7rem; border:1px solid #d1d5db; border-radius:8px;">
                    <option value="agent">Agen</option>
                    <option value="admin">Admin</option>
                    <option value="owner">Owner</option>
                </select>
            </div>
            <button type="submit"
                style="width:100%; padding:0.9rem; background:#4f46e5; color:white; border:none; border-radius:10px; font-weight:600; cursor:pointer;">Simpan
                Agen</button>
        </form>
    </div>

</div>

<style>
    @media (max-width: 900px) {
        .user-management-grid {
            grid-template-columns: 1fr !important;
        }

        .card {
            padding: 1.5rem !important;
        }
    }
</style>

<?php include __DIR__ . '/../../layout/footer.php'; ?>