<?php
$pageTitle = 'Data Analitik';
include __DIR__ . '/../layout/header.php';
?>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
    <!-- KPI Cards -->
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <div style="color: #6b7280; font-size: 0.9rem; font-weight: 500; margin-bottom: 0.5rem;">Est. Profit Total</div>
        <div style="font-size: 1.8rem; font-weight: 700; color: #10b981;">Rp <?= number_format($totalProfit, 0) ?></div>
        <div style="font-size: 0.8rem; color: #10b981;">+ Net Income</div>
    </div>
    
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <div style="color: #6b7280; font-size: 0.9rem; font-weight: 500; margin-bottom: 0.5rem;">Total Transaksi</div>
        <div style="font-size: 1.8rem; font-weight: 700; color: #111827;"><?= number_format($totalVolume) ?></div>
        <div style="font-size: 0.8rem; color: #6b7280;">Volume Penjualan</div>
    </div>

    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <div style="color: #6b7280; font-size: 0.9rem; font-weight: 500; margin-bottom: 0.5rem;">Rata-rata Transaksi</div>
        <div style="font-size: 1.8rem; font-weight: 700; color: #4f46e5;">Rp <?= number_format($avgTransaction, 0) ?></div>
        <div style="font-size: 0.8rem; color: #6b7280;">Per Transaksi</div>
    </div>

    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <div style="color: #6b7280; font-size: 0.9rem; font-weight: 500; margin-bottom: 0.5rem;">Success Rate</div>
        <div style="font-size: 1.8rem; font-weight: 700; color: #059669;"><?= $successRate ?>%</div>
        <div style="font-size: 0.8rem; color: #6b7280;">Tingkat Keberhasilan</div>
    </div>
</div>

<!-- Charts Row -->
<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 1.5rem; margin-bottom: 2rem;">
    <!-- Main Trend Chart -->
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h3 style="margin-top: 0; color: #374151; margin-bottom: 1rem;">Tren Keuangan (6 Bulan Terakhir)</h3>
        <canvas id="balanceChart" height="300"></canvas>
    </div>

    <!-- Category Pie Chart -->
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h3 style="margin-top: 0; color: #374151; margin-bottom: 1rem;">Top Pengeluaran</h3>
        <canvas id="categoryChart" height="250"></canvas>
        <div style="margin-top: 1rem;">
             <?php foreach(array_slice($expenseCategories, 0, 3) as $cat): ?>
                <div style="display: flex; justify-content: space-between; font-size: 0.85rem; padding: 0.5rem 0; border-bottom: 1px solid #f3f4f6;">
                    <span><?= htmlspecialchars($cat['name']) ?></span>
                    <span style="font-weight: 600;">Rp <?= number_format($cat['total']/1000, 0) ?>k</span>
                </div>
             <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Additional Charts Row (Bank & Status) -->
<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 2rem;">
    <!-- Bank Profit Chart -->
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h3 style="margin-top: 0; color: #374151; margin-bottom: 1rem;">Pemasukan per Bank</h3>
        <canvas id="bankChart" height="200"></canvas>
    </div>

    <!-- Status Breakdown Chart -->
    <div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h3 style="margin-top: 0; color: #374151; margin-bottom: 1rem;">Status Transaksi</h3>
        <div style="height: 200px; display:flex; justify-content:center;">
             <canvas id="statusChart"></canvas>
        </div>
    </div>
</div>

<!-- Top Products Table -->
<div class="card" style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
    <h3 style="margin-top: 0; color: #374151; margin-bottom: 1rem;">Top Produk Terlaris</h3>
    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 2px solid #f3f4f6;">
                    <th style="padding: 1rem; color: #6b7280;">Kode</th>
                    <th style="padding: 1rem; color: #6b7280;">Nama Layanan</th>
                    <th style="padding: 1rem; color: #6b7280;">Total Penjualan</th>
                    <th style="padding: 1rem; color: #6b7280;">Total Profit</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($topServices as $svc): ?>
                <tr style="border-bottom: 1px solid #f9fafb;">
                    <td style="padding: 1rem; font-family: monospace; font-weight: 600;"><?= htmlspecialchars($svc['code']) ?></td>
                    <td style="padding: 1rem;"><?= htmlspecialchars($svc['name']) ?></td>
                    <td style="padding: 1rem; font-weight: 600;"><?= number_format($svc['sales_count']) ?>x</td>
                    <td style="padding: 1rem; color: #10b981; font-weight: 600;">+ Rp <?= number_format($svc['total_profit'], 0) ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($topServices)): ?>
                    <tr><td colspan="4" style="padding: 1rem; text-align: center; color: #9ca3af;">Belum ada data penjualan produk.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // 1. Balance Trend Chart
    const ctxBalance = document.getElementById('balanceChart').getContext('2d');
    new Chart(ctxBalance, {
        type: 'line',
        data: {
            labels: <?= json_encode($monthlyTrend['labels']) ?>,
            datasets: [
                {
                    label: 'Pemasukan',
                    data: <?= json_encode($monthlyTrend['income']) ?>,
                    borderColor: '#10b981',
                    backgroundColor: 'rgba(16, 185, 129, 0.1)',
                    fill: true,
                    tension: 0.4
                },
                {
                    label: 'Pengeluaran',
                    data: <?= json_encode($monthlyTrend['expense']) ?>,
                    borderColor: '#ef4444',
                    backgroundColor: 'rgba(239, 68, 68, 0.1)',
                    fill: true,
                    tension: 0.4
                }
            ]
        },
        options: {
            responsive: true,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: { position: 'top' }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) { return 'Rp ' + (value/1000000).toFixed(1) + 'jt'; }
                    }
                }
            }
        }
    });

    // 2. Category Donut Chart
    const ctxCat = document.getElementById('categoryChart').getContext('2d');
    const catData = <?= json_encode(array_column($expenseCategories, 'total')) ?>;
    const catLabels = <?= json_encode(array_column($expenseCategories, 'name')) ?>;
    
    new Chart(ctxCat, {
        type: 'doughnut',
        data: {
            labels: catLabels,
            datasets: [{
                data: catData,
                backgroundColor: [
                    '#4f46e5',
                    '#ec4899',
                    '#f59e0b',
                    '#10b981',
                    '#6366f1'
                ],
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'bottom', labels: { boxWidth: 12 } }
            },
            cutout: '70%'
        }
    });

    // 3. Bank Profit Bar Chart
    const ctxBank = document.getElementById('bankChart').getContext('2d');
    new Chart(ctxBank, {
        type: 'bar',
        data: {
            labels: <?= json_encode(array_column($bankProfit, 'name')) ?>,
            datasets: [{
                label: 'Total Pemasukan',
                data: <?= json_encode(array_column($bankProfit, 'total')) ?>,
                backgroundColor: '#3b82f6',
                borderRadius: 6
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: false } },
            scales: {
                y: { beginAtZero: true, ticks: { callback: function(val){return (val/1000000).toFixed(0)+'M'} } }
            }
        }
    });

    // 4. Status Pie Chart
    const ctxStatus = document.getElementById('statusChart').getContext('2d');
    const statusData = <?= json_encode($statusBreakdown) ?>;
    const statusLabels = statusData.map(item => item.status.toUpperCase());
    const statusCounts = statusData.map(item => item.count);
    const statusColors = statusLabels.map(s => {
        if(s === 'SUCCESS') return '#10b981';
        if(s === 'PENDING') return '#f59e0b';
        return '#ef4444';
    });

    new Chart(ctxStatus, {
        type: 'pie',
        data: {
            labels: statusLabels,
            datasets: [{
                data: statusCounts,
                backgroundColor: statusColors,
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { position: 'right' } }
        }
    });
</script>

<style>
    /* Responsive Chart Grid */
    @media (max-width: 900px) {
        div[style*="grid-template-columns: 2fr 1fr"] {
            grid-template-columns: 1fr !important;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>
