<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Login - PPOB Banyuwangi Reload</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #4f46e5 0%, #3b82f6 100%);
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .login-card {
            background: rgba(255, 255, 255, 0.95);
            padding: 2.5rem;
            border-radius: 24px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            text-align: center;
        }

        .brand {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        h1 {
            margin: 0 0 1.5rem 0;
            font-size: 1.5rem;
            color: #1f2937;
        }

        .form-group {
            margin-bottom: 1.25rem;
            text-align: left;
        }

        label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            color: #374151;
            margin-bottom: 0.5rem;
        }

        input {
            width: 100%;
            padding: 0.75rem 0;
            text-indent: 1rem;
            border-radius: 12px;
            border: 1px solid #d1d5db;
            font-size: 1rem;
        }

        button {
            width: 100%;
            padding: 0.875rem;
            background: #4f46e5;
            color: white;
            border: none;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            margin-top: 1rem;
        }

        .error {
            color: #ef4444;
            font-size: 0.875rem;
            margin-bottom: 1rem;
        }

        .hint {
            color: #6b7280;
            font-size: 0.75rem;
            margin-top: 1rem;
        }
    </style>
</head>

<body>
    <div class="login-card">
        <div class="brand">💰</div>
        <h1>PPOB Banyuwangi Reload</h1>

        <?php if (isset($error)): ?>
            <div class="error"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST" action="index.php?page=login">
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" required placeholder="admin">
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" required placeholder="••••••••">
            </div>
            <button type="submit">Masuk Sistem</button>
        </form>
        <div class="hint">Default: admin / password123</div>
    </div>
</body>

</html>