<?php
$pageTitle = 'Setor Tunai';
include __DIR__ . '/../layout/header.php';
?>

<div class="card" style="background: white; padding: 2rem; border-radius: 20px; max-width: 600px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
        <h2 style="margin: 0;">Setor Tunai</h2>
        <a href="index.php?page=banking" style="color: #6b7280; text-decoration: none;">← Kembali</a>
    </div>

    <?php if (isset($_GET['error'])): ?>
        <div style="background: #fee2e2; color: #b91c1c; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
            ✗ Terjadi kesalahan. Silakan coba lagi.
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=banking/deposit">
        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Rekening Tujuan</label>
            <select name="account_id" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Pilih Rekening</option>
                <?php foreach ($accounts as $acc): ?>
                    <option value="<?= $acc['id'] ?>">
                        <?= htmlspecialchars($acc['bank_name']) ?> - <?= htmlspecialchars($acc['account_number']) ?>
                        (<?= htmlspecialchars($acc['account_name']) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Jumlah Setoran</label>
            <input type="number" name="amount" min="1" step="1" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Masukkan jumlah">
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Kategori (Opsional)</label>
            <select name="category_id"
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Tanpa Kategori</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 2rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Keterangan</label>
            <input type="text" name="description" maxlength="200"
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Setoran Tunai (opsional)">
        </div>

        <button type="submit"
            style="width: 100%; padding: 1rem; background: #10b981; color: white; border: none; border-radius: 10px; font-weight: 600; font-size: 1rem; cursor: pointer;">
            Proses Setoran
        </button>
    </form>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>