<?php
$pageTitle = 'Perbankan';
include __DIR__ . '/../layout/header.php';
?>

<?php if (isset($_GET['success'])): ?>
    <div style="background: #ecfdf5; color: #047857; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
        <?php if ($_GET['success'] == 'transfer'): ?>
            ✓ Transfer berhasil dilakukan!
        <?php elseif ($_GET['success'] == 'deposit'): ?>
            ✓ Setoran berhasil dicatat!
        <?php elseif ($_GET['success'] == 'withdraw'): ?>
            ✓ Penarikan berhasil dilakukan!
        <?php endif; ?>
    </div>
<?php endif; ?>

<!-- Premium Banking Dashboard -->
<div style="width: 100%; margin: 0;">

    <!-- Account Cards Carousel (Horizontal Scroll) -->
    <div style="margin-bottom: 2rem;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
            <h2 style="margin: 0; font-size: 1.25rem; color: #1f2937;">Rekening Saya</h2>
            <div style="font-size: 0.9rem; color: #6b7280;">Total: <span style="color: #111827; font-weight: 700;">Rp
                    <?= number_format($totalBalance, 0) ?></span></div>
        </div>

        <div style="display: flex; gap: 1.5rem; overflow-x: auto; padding-bottom: 1rem; scroll-behavior: smooth;">
            <?php foreach ($accounts as $acc):
                $gradients = [
                    'BCA' => 'linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%)',
                    'BRI' => 'linear-gradient(135deg, #0ea5e9 0%, #2563eb 100%)',
                    'BNI' => 'linear-gradient(135deg, #f97316 0%, #ea580c 100%)',
                    'MANDIRI' => 'linear-gradient(135deg, #eab308 0%, #ca8a04 100%)',
                    'default' => 'linear-gradient(135deg, #1f2937 0%, #111827 100%)'
                ];
                $bg = $gradients[strtoupper($acc['bank_name'])] ?? $gradients['default'];
                ?>
                <a href="index.php?page=banking/details&id=<?= $acc['id'] ?>"
                    style="text-decoration: none; flex: 0 0 auto;">
                    <div class="bank-card"
                        style="width: 320px; height: 190px; border-radius: 20px; padding: 1.5rem; color: white; background: <?= $bg ?>; position: relative; display: flex; flex-direction: column; justify-content: space-between; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1); cursor: pointer; transition: transform 0.2s;">
                        <div style="display: flex; justify-content: space-between; align-items: flex-start;">
                            <div>
                                <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">
                                    <?= htmlspecialchars($acc['bank_name']) ?>
                                </div>
                                <div style="font-size: 1.1rem; font-weight: 600; letter-spacing: 1px;">
                                    <?= htmlspecialchars($acc['account_number']) ?>
                                </div>
                            </div>
                            <div style="font-size: 1.5rem;">💳</div>
                        </div>

                        <div>
                            <div style="font-size: 0.8rem; opacity: 0.8; margin-bottom: 0.25rem;">Saldo Tersedia</div>
                            <div style="font-size: 1.75rem; font-weight: 700;">Rp <?= number_format($acc['balance'], 0) ?>
                            </div>
                            <div style="font-size: 0.9rem; margin-top: 0.5rem;">
                                <?= htmlspecialchars($acc['account_name']) ?>
                            </div>
                        </div>

                        <!-- Shine Effect -->
                        <div
                            style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 100%); border-radius: 20px; pointer-events: none;">
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>

            <!-- Add New Account Placeholder -->
            <div
                style="width: 320px; height: 190px; border-radius: 20px; border: 2px dashed #e5e7eb; display: flex; flex-direction: column; justify-content: center; align-items: center; color: #9ca3af; cursor: pointer; flex: 0 0 auto; background: #f9fafb;">
                <div style="font-size: 2rem; margin-bottom: 0.5rem;">+</div>
                <div style="font-weight: 500;">Tambah Rekening</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions & Stats Grid -->
    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem; margin-bottom: 2rem;">

        <!-- Left Column: Quick Actions -->
        <div>
            <h3 style="margin: 0 0 1rem 0; font-size: 1.1rem; color: #374151;">Aksi Cepat</h3>
            <div style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 1rem;">
                <!-- Transfer -->
                <a href="index.php?page=banking/transfer" style="text-decoration: none; color: inherit;">
                    <div class="action-btn"
                        style="background: white; border-radius: 16px; padding: 1.25rem 0.5rem; text-align: center; border: 1px solid #f3f4f6; transition: all 0.2s;">
                        <div
                            style="background: #e0e7ff; width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin: 0 auto 0.75rem auto; color: #4f46e5;">
                            💸</div>
                        <div style="font-size: 0.8rem; font-weight: 600; color: #4b5563;">Transfer</div>
                    </div>
                </a>

                <!-- Setor -->
                <a href="index.php?page=banking/deposit" style="text-decoration: none; color: inherit;">
                    <div class="action-btn"
                        style="background: white; border-radius: 16px; padding: 1.25rem 0.5rem; text-align: center; border: 1px solid #f3f4f6; transition: all 0.2s;">
                        <div
                            style="background: #dcfce7; width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin: 0 auto 0.75rem auto; color: #16a34a;">
                            💰</div>
                        <div style="font-size: 0.8rem; font-weight: 600; color: #4b5563;">Setor</div>
                    </div>
                </a>

                <!-- Tarik -->
                <a href="index.php?page=banking/withdraw" style="text-decoration: none; color: inherit;">
                    <div class="action-btn"
                        style="background: white; border-radius: 16px; padding: 1.25rem 0.5rem; text-align: center; border: 1px solid #f3f4f6; transition: all 0.2s;">
                        <div
                            style="background: #fee2e2; width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin: 0 auto 0.75rem auto; color: #dc2626;">
                            🏧</div>
                        <div style="font-size: 0.8rem; font-weight: 600; color: #4b5563;">Tarik</div>
                    </div>
                </a>

                <!-- PPOB/Topup -->
                <a href="index.php?page=ppob" style="text-decoration: none; color: inherit;">
                    <div class="action-btn"
                        style="background: white; border-radius: 16px; padding: 1.25rem 0.5rem; text-align: center; border: 1px solid #f3f4f6; transition: all 0.2s;">
                        <div
                            style="background: #ffedd5; width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin: 0 auto 0.75rem auto; color: #ea580c;">
                            📱</div>
                        <div style="font-size: 0.8rem; font-weight: 600; color: #4b5563;">Top Up</div>
                    </div>
                </a>

                <!-- Bayar -->
                <a href="index.php?page=ppob" style="text-decoration: none; color: inherit;">
                    <div class="action-btn"
                        style="background: white; border-radius: 16px; padding: 1.25rem 0.5rem; text-align: center; border: 1px solid #f3f4f6; transition: all 0.2s;">
                        <div
                            style="background: #f3f4f6; width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin: 0 auto 0.75rem auto; color: #4b5563;">
                            ⚡</div>
                        <div style="font-size: 0.8rem; font-weight: 600; color: #4b5563;">Tagihan</div>
                    </div>
                </a>
            </div>

            <h3 style="margin: 1.5rem 0 1rem 0; font-size: 1.1rem; color: #374151;">Mutasi Terakhir</h3>
            <div style="background: white; border-radius: 16px; padding: 0.5rem; border: 1px solid #f3f4f6;">
                <?php if (empty($recentTransactions)): ?>
                    <div style="padding: 2rem; text-align: center; color: #9ca3af; font-size: 0.9rem;">
                        Belum ada transaksi
                    </div>
                <?php else: ?>
                    <?php foreach ($recentTransactions as $idx => $trx): ?>
                        <div
                            style="display: flex; justify-content: space-between; align-items: center; padding: 1rem; <?= $idx < count($recentTransactions) - 1 ? 'border-bottom: 1px solid #f3f4f6;' : '' ?>">
                            <div style="display: flex; gap: 1rem; align-items: center;">
                                <div
                                    style="width: 40px; height: 40px; border-radius: 10px; background: <?= $trx['transaction_type'] == 'credit' ? '#dcfce7' : '#fee2e2' ?>; display: flex; align-items: center; justify-content: center; font-size: 1.2rem;">
                                    <?= $trx['transaction_type'] == 'credit' ? '↙' : '↗' ?>
                                </div>
                                <div>
                                    <div style="font-weight: 600; font-size: 0.9rem; color: #1f2937;">
                                        <?= htmlspecialchars($trx['description'] ?: 'No Description') ?>
                                    </div>
                                    <div style="font-size: 0.75rem; color: #6b7280;">
                                        <?= date('d M • H:i', strtotime($trx['transaction_date'])) ?> |
                                        <?= htmlspecialchars($trx['bank_name']) ?>
                                    </div>
                                </div>
                            </div>
                            <div
                                style="font-weight: 600; font-size: 0.95rem; color: <?= $trx['transaction_type'] == 'credit' ? '#059669' : '#dc2626' ?>">
                                <?= $trx['transaction_type'] == 'credit' ? '+' : '-' ?> Rp
                                <?= number_format($trx['amount'], 0) ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

                <a href="index.php?page=history"
                    style="display: block; text-align: center; padding: 0.75rem; color: #4f46e5; font-weight: 500; font-size: 0.9rem; text-decoration: none; border-top: 1px solid #f3f4f6;">
                    Lihat Semua Riwayat →
                </a>
            </div>
        </div>

        <!-- Right Column: Stats -->
        <div>
            <h3 style="margin: 0 0 1rem 0; font-size: 1.1rem; color: #374151;">Ringkasan Bulan Ini</h3>

            <!-- Income Card -->
            <div
                style="background: white; padding: 1.25rem; border-radius: 16px; margin-bottom: 1rem; border: 1px solid #f3f4f6;">
                <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.5rem;">
                    <div
                        style="background: #dcfce7; color: #16a34a; width: 32px; height: 32px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                        ↓</div>
                    <span style="color: #6b7280; font-size: 0.9rem; font-weight: 500;">Pemasukan</span>
                </div>
                <div style="font-size: 1.25rem; font-weight: 700; color: #111827;">Rp
                    <?= number_format($monthlyIncome, 0) ?>
                </div>
            </div>

            <!-- Expense Card -->
            <div
                style="background: white; padding: 1.25rem; border-radius: 16px; margin-bottom: 1rem; border: 1px solid #f3f4f6;">
                <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.5rem;">
                    <div
                        style="background: #fee2e2; color: #dc2626; width: 32px; height: 32px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                        ↑</div>
                    <span style="color: #6b7280; font-size: 0.9rem; font-weight: 500;">Pengeluaran</span>
                </div>
                <div style="font-size: 1.25rem; font-weight: 700; color: #111827;">Rp
                    <?= number_format($monthlyExpense, 0) ?>
                </div>
            </div>

            <!-- Cash Flow Chart Placeholder could be added here -->
            <div
                style="background: linear-gradient(135deg, #1f2937 0%, #111827 100%); padding: 1.5rem; border-radius: 16px; color: white;">
                <div style="font-size: 0.9rem; margin-bottom: 0.5rem; opacity: 0.8;">Cash Flow</div>
                <div style="font-size: 1.1rem; font-weight: 600;">Net: Rp
                    <?= number_format($monthlyIncome - $monthlyExpense, 0) ?>
                </div>
                <div
                    style="margin-top: 1rem; height: 4px; background: rgba(255,255,255,0.1); border-radius: 2px; overflow: hidden;">
                    <?php
                    $totalFlow = $monthlyIncome + $monthlyExpense;
                    $incomePercent = $totalFlow > 0 ? ($monthlyIncome / $totalFlow) * 100 : 50;
                    ?>
                    <div style="width: <?= $incomePercent ?>%; height: 100%; background: #4f46e5;"></div>
                </div>
                <div
                    style="display: flex; justify-content: space-between; margin-top: 0.5rem; font-size: 0.75rem; opacity: 0.7;">
                    <span><?= number_format($incomePercent, 0) ?>% In</span>
                    <span><?= number_format(100 - $incomePercent, 0) ?>% Out</span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .bank-card:hover {
        transform: translateY(-5px);
    }

    .action-btn:hover {
        background: #f9fafb !important;
        transform: translateY(-2px);
        border-color: #d1d5db !important;
    }

    @media (max-width: 768px) {
        div[style*="grid-template-columns: 2fr 1fr"] {
            grid-template-columns: 1fr !important;
        }

        .action-btn {
            padding: 1rem 0.25rem !important;
        }

        .action-btn div[style*="font-size: 1.5rem"] {
            font-size: 1.2rem !important;
            width: 40px !important;
            height: 40px !important;
        }

        .action-btn div[style*="font-size: 0.8rem"] {
            font-size: 0.7rem !important;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>