<?php
$pageTitle = 'Transfer';
include __DIR__ . '/../layout/header.php';
?>

<div class="card" style="background: white; padding: 2rem; border-radius: 20px; max-width: 600px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
        <h2 style="margin: 0;">Transfer Antar Rekening</h2>
        <a href="index.php?page=banking" style="color: #6b7280; text-decoration: none;">← Kembali</a>
    </div>

    <?php if (isset($_GET['error'])): ?>
        <div style="background: #fee2e2; color: #b91c1c; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
            <?php if ($_GET['error'] == 'same_account'): ?>
                ✗ Rekening tujuan tidak boleh sama dengan rekening sumber!
            <?php elseif ($_GET['error'] == 'insufficient_balance'): ?>
                ✗ Saldo tidak mencukupi untuk transfer!
            <?php elseif ($_GET['error'] == 'invalid_amount'): ?>
                ✗ Jumlah transfer tidak valid!
            <?php else: ?>
                ✗ Terjadi kesalahan. Silakan coba lagi.
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=banking/transfer" onsubmit="return confirm('Lanjutkan transfer?')">
        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Dari Rekening</label>
            <select name="from_account" id="fromAccount" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Pilih Rekening</option>
                <?php foreach ($accounts as $acc): ?>
                    <option value="<?= $acc['id'] ?>" data-balance="<?= $acc['balance'] ?>">
                        <?= htmlspecialchars($acc['bank_name']) ?> - <?= htmlspecialchars($acc['account_number']) ?>
                        (Rp <?= number_format($acc['balance'], 0) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Ke Rekening</label>
            <select name="to_account" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Pilih Rekening</option>
                <?php foreach ($accounts as $acc): ?>
                    <option value="<?= $acc['id'] ?>">
                        <?= htmlspecialchars($acc['bank_name']) ?> - <?= htmlspecialchars($acc['account_number']) ?>
                        (<?= htmlspecialchars($acc['account_name']) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Jumlah Transfer</label>
            <input type="number" name="amount" id="amount" min="1" step="1" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Masukkan jumlah">
            <div id="balanceWarning" style="color: #dc2626; font-size: 0.85rem; margin-top: 0.5rem; display: none;">
                ⚠️ Saldo tidak mencukupi!
            </div>
        </div>

        <div style="margin-bottom: 2rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Keterangan</label>
            <input type="text" name="description" maxlength="200"
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Transfer (opsional)">
        </div>

        <button type="submit" id="submitBtn"
            style="width: 100%; padding: 1rem; background: #4f46e5; color: white; border: none; border-radius: 10px; font-weight: 600; font-size: 1rem; cursor: pointer;">
            Transfer Sekarang
        </button>
    </form>
</div>

<script>
    const fromAccount = document.getElementById('fromAccount');
    const amountInput = document.getElementById('amount');
    const balanceWarning = document.getElementById('balanceWarning');
    const submitBtn = document.getElementById('submitBtn');

    function checkBalance() {
        const selectedOption = fromAccount.options[fromAccount.selectedIndex];
        const balance = parseFloat(selectedOption.dataset.balance || 0);
        const amount = parseFloat(amountInput.value || 0);

        if (amount > balance) {
            balanceWarning.style.display = 'block';
            submitBtn.disabled = true;
            submitBtn.style.opacity = '0.5';
        } else {
            balanceWarning.style.display = 'none';
            submitBtn.disabled = false;
            submitBtn.style.opacity = '1';
        }
    }

    fromAccount.addEventListener('change', checkBalance);
    amountInput.addEventListener('input', checkBalance);
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>