<?php
$pageTitle = 'Tarik Tunai';
include __DIR__ . '/../layout/header.php';
?>

<div class="card" style="background: white; padding: 2rem; border-radius: 20px; max-width: 600px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
        <h2 style="margin: 0;">Tarik Tunai</h2>
        <a href="index.php?page=banking" style="color: #6b7280; text-decoration: none;">← Kembali</a>
    </div>

    <?php if (isset($_GET['error'])): ?>
        <div style="background: #fee2e2; color: #b91c1c; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
            <?php if ($_GET['error'] == 'insufficient_balance'): ?>
                ✗ Saldo tidak mencukupi untuk penarikan!
            <?php else: ?>
                ✗ Terjadi kesalahan. Silakan coba lagi.
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=banking/withdraw">
        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Rekening Sumber</label>
            <select name="account_id" id="accountSelect" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Pilih Rekening</option>
                <?php foreach ($accounts as $acc): ?>
                    <option value="<?= $acc['id'] ?>" data-balance="<?= $acc['balance'] ?>">
                        <?= htmlspecialchars($acc['bank_name']) ?> - <?= htmlspecialchars($acc['account_number']) ?>
                        (Rp <?= number_format($acc['balance'], 0) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Jumlah Penarikan</label>
            <input type="number" name="amount" id="amountInput" min="1" step="1" required
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Masukkan jumlah">
            <div id="balanceWarning" style="color: #dc2626; font-size: 0.85rem; margin-top: 0.5rem; display: none;">
                ⚠️ Saldo tidak mencukupi!
            </div>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Kategori (Opsional)</label>
            <select name="category_id"
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                <option value="">Tanpa Kategori</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom: 2rem;">
            <label style="display: block; font-weight: 500; margin-bottom: 0.5rem;">Keterangan</label>
            <input type="text" name="description" maxlength="200"
                style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;"
                placeholder="Penarikan Tunai (opsional)">
        </div>

        <button type="submit" id="submitBtn"
            style="width: 100%; padding: 1rem; background: #dc2626; color: white; border: none; border-radius: 10px; font-weight: 600; font-size: 1rem; cursor: pointer;">
            Proses Penarikan
        </button>
    </form>
</div>

<script>
    const accountSelect = document.getElementById('accountSelect');
    const amountInput = document.getElementById('amountInput');
    const balanceWarning = document.getElementById('balanceWarning');
    const submitBtn = document.getElementById('submitBtn');

    function checkBalance() {
        const selectedOption = accountSelect.options[accountSelect.selectedIndex];
        const balance = parseFloat(selectedOption.dataset.balance || 0);
        const amount = parseFloat(amountInput.value || 0);

        if (amount > balance) {
            balanceWarning.style.display = 'block';
            submitBtn.disabled = true;
            submitBtn.style.opacity = '0.5';
        } else {
            balanceWarning.style.display = 'none';
            submitBtn.disabled = false;
            submitBtn.style.opacity = '1';
        }
    }

    accountSelect.addEventListener('change', checkBalance);
    amountInput.addEventListener('input', checkBalance);
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>