<?php
$pageTitle = 'Daftar Bank';
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
    <div class="header-actions"
        style="display:flex; justify-content:space-between; align-items:center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
        <h2 style="margin:0; font-size:1.25rem;">Bank Terdaftar</h2>
        <a href="index.php?page=banks/create"
            style="background: #4f46e5; color: white; text-decoration: none; padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 500; font-size: 0.9rem;">+
            Tambah Bank</a>
    </div>

    <?php if (isset($_GET['success'])): ?>
        <div style="background: #ecfdf5; color: #047857; padding: 1rem; border-radius: 12px; margin-bottom: 1rem;">
            Bank berhasil ditambahkan!
        </div>
    <?php endif; ?>

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; min-width: 600px;">
            <thead>
                <tr style="border-bottom: 2px solid #f3f4f6;">
                    <th style="text-align: left; padding: 1rem; color: #6b7280;">NAMA BANK</th>
                    <th style="text-align: left; padding: 1rem; color: #6b7280;">API ENDPOINT</th>
                    <th style="text-align: left; padding: 1rem; color: #6b7280;">AKSI</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($banks as $bank): ?>
                    <tr style="border-bottom: 1px solid #f3f4f6;">
                        <td style="padding: 1rem; font-weight: 600;"><?= htmlspecialchars($bank['name']) ?></td>
                        <td style="padding: 1rem; color: #6b7280; font-family: monospace;">
                            <?= $bank['api_endpoint'] ?: '-' ?>
                        </td>
                        <td style="padding: 1rem;">
                            <a href="index.php?page=banks/show&id=<?= $bank['id'] ?>"
                                style="background:#f3f4f6; color:#374151; padding:0.3rem 0.8rem; border-radius:6px; text-decoration:none; font-size:0.85rem; font-weight:500; margin-right: 0.5rem;">Lihat
                                History</a>
                            <a href="index.php?page=banks/edit&id=<?= $bank['id'] ?>"
                                style="background:#e0e7ff; color:#4338ca; padding:0.3rem 0.8rem; border-radius:6px; text-decoration:none; font-size:0.85rem; font-weight:500;">Edit</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
    @media (max-width: 768px) {
        .card {
            padding: 1.5rem !important;
        }

        .header-actions {
            flex-direction: column;
            align-items: stretch;
            text-align: center;
        }

        .header-actions a {
            display: block;
            text-align: center;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>