<?php
$pageTitle = 'Riwayat Transaksi - ' . htmlspecialchars($bank['name']);
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
    <div class="header-actions"
        style="display:flex; justify-content:space-between; align-items:center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
        <div>
            <h2 style="margin:0; font-size:1.25rem;">Riwayat Transaksi: <?= htmlspecialchars($bank['name']) ?></h2>
            <p style="color:#6b7280; margin:0.25rem 0 0 0; font-size:0.9rem;">Daftar semua mutasi untuk bank ini.</p>
        </div>
        <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
            <form method="POST" action="index.php?page=banks/import&id=<?= $bank['id'] ?>" enctype="multipart/form-data"
                style="display: inline-flex; gap: 0.5rem; align-items: center;">
                <input type="file" name="csv_file" accept=".csv" required
                    style="padding: 0.5rem; border: 1px solid #d1d5db; border-radius: 8px; font-size: 0.85rem; max-width: 200px;">
                <button type="submit"
                    style="background: #10b981; color: white; padding: 0.6rem 1rem; border: none; border-radius: 8px; font-weight: 500; cursor: pointer; font-size: 0.85rem; white-space: nowrap;">
                    📥 Import CSV
                </button>
            </form>
            <a href="index.php?page=banks"
                style="background: #f3f4f6; color: #374151; text-decoration: none; padding: 0.6rem 1.5rem; border-radius: 12px; font-weight: 500; font-size: 0.9rem;">
                ← Kembali
            </a>
        </div>
    </div>

    <?php if (isset($_GET['imported'])): ?>
        <div style="background: #ecfdf5; color: #047857; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
            ✓ Berhasil mengimpor <?= intval($_GET['imported']) ?> transaksi.
            <?php if (isset($_GET['skipped']) && $_GET['skipped'] > 0): ?>
                (<?= intval($_GET['skipped']) ?> baris dilewati)
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div style="background: #fee2e2; color: #b91c1c; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem;">
            ✗ Gagal mengimpor file. Pastikan format CSV sudah benar.
        </div>
    <?php endif; ?>

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; min-width: 800px;">
            <thead>
                <tr style="border-bottom: 2px solid #f3f4f6; text-align: left;">
                    <th style="padding: 1rem; color: #6b7280;">Waktu</th>
                    <th style="padding: 1rem; color: #6b7280;">Rekening</th>
                    <th style="padding: 1rem; color: #6b7280;">Deskripsi</th>
                    <th style="padding: 1rem; color: #6b7280;">Nominal</th>
                    <th style="padding: 1rem; color: #6b7280;">Kategori</th>
                    <th style="padding: 1rem; color: #6b7280;">Status</th>
                    <th style="padding: 1rem; color: #6b7280;">Eksekutor</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $trx): ?>
                    <tr style="border-bottom: 1px solid #f3f4f6;">
                        <td style="padding: 1rem; font-size: 0.9rem;">
                            <div style="font-weight: 500; color: #111827;">
                                <?= date('d M Y', strtotime($trx['transaction_date'])) ?>
                            </div>
                            <div style="font-size: 0.75rem; color: #6b7280;">
                                <?= date('H:i:s', strtotime($trx['transaction_date'])) ?> WIB
                            </div>
                        </td>
                        <td style="padding: 1rem;">
                            <div style="font-weight: 500;"><?= htmlspecialchars($trx['account_number']) ?></div>
                            <div style="font-size: 0.8rem; color: #6b7280;"><?= htmlspecialchars($trx['account_name']) ?>
                            </div>
                        </td>
                        <td style="padding: 1rem; font-size: 0.9rem; max-width: 250px;">
                            <?= htmlspecialchars($trx['description']) ?>
                        </td>
                        <td style="padding: 1rem;">
                            <span
                                style="font-weight: 600; color: <?= $trx['transaction_type'] == 'credit' ? '#059669' : '#dc2626' ?>">
                                <?= $trx['transaction_type'] == 'credit' ? '+' : '-' ?> Rp
                                <?= number_format($trx['amount'], 0) ?>
                            </span>
                        </td>
                        <td style="padding: 1rem;">
                            <span
                                style="background: #f3f4f6; padding: 0.2rem 0.6rem; border-radius: 6px; font-size: 0.8rem;">
                                <?= htmlspecialchars($trx['category_name'] ?: '-') ?>
                            </span>
                        </td>
                        <td style="padding: 1rem;">
                            <?php
                            $statusColors = [
                                'success' => ['bg' => '#d1fae5', 'text' => '#065f46'],
                                'pending' => ['bg' => '#fef3c7', 'text' => '#92400e'],
                                'failed' => ['bg' => '#fee2e2', 'text' => '#b91c1c']
                            ];
                            $s = $trx['status'] ?? 'pending';
                            $color = $statusColors[$s] ?? $statusColors['pending'];
                            ?>
                            <span
                                style="display: inline-block; padding: 0.25rem 0.75rem; border-radius: 9999px; font-size: 0.75rem; font-weight: 600; background-color: <?= $color['bg'] ?>; color: <?= $color['text'] ?>; text-transform: uppercase;">
                                <?= $s ?>
                            </span>
                        </td>
                        <td style="padding: 1rem; font-size: 0.85rem; color: #4b5563;">
                            <?= htmlspecialchars($trx['executor_name'] ?: 'Sistem') ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($transactions)): ?>
                    <tr>
                        <td colspan="7" style="padding: 2rem; text-align: center; color: #9ca3af;">Belum ada riwayat
                            transaksi.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
    @media (max-width: 768px) {
        .card {
            padding: 1.5rem !important;
        }

        .header-actions {
            flex-direction: column;
            align-items: stretch;
            text-align: center;
        }

        .header-actions a {
            display: block;
            text-align: center;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>