<?php
$pageTitle = 'Dashboard Overview';
include __DIR__ . '/layout/header.php';
?>

<style>
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .stat-card {
        background: white;
        padding: 1.5rem;
        border-radius: 20px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .stat-label {
        color: #6b7280;
        font-size: 0.9rem;
        font-weight: 500;
    }

    .stat-value {
        font-size: 1.8rem;
        font-weight: 700;
        color: #111827;
    }

    .stat-card.balance .stat-value {
        color: #4f46e5;
    }

    .stat-card.income .stat-value {
        color: #10b981;
    }

    .stat-card.expense .stat-value {
        color: #ef4444;
    }

    .section-title {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 1rem;
        color: #374151;
    }

    .charts-container {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .chart-box {
        background: white;
        padding: 1.5rem;
        border-radius: 20px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
    }

    .bank-list {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .bank-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1rem;
        border-bottom: 1px solid #f3f4f6;
    }

    .bank-item:last-child {
        border-bottom: none;
    }

    .bank-info {
        font-weight: 600;
    }

    .bank-balance {
        font-family: monospace;
        font-size: 1rem;
    }

    .recent-table-container {
        background: white;
        padding: 1.5rem;
        border-radius: 20px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th {
        text-align: left;
        color: #6b7280;
        padding: 1rem;
        font-size: 0.85rem;
    }

    td {
        padding: 1rem;
        border-top: 1px solid #f3f4f6;
        font-size: 0.95rem;
    }

    .badge {
        padding: 0.25rem 0.75rem;
        border-radius: 99px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .badge-debit {
        background: #fee2e2;
        color: #ef4444;
    }

    .badge-credit {
        background: #d1fae5;
        color: #10b981;
    }

    /* Mobile Dashboard Optimizations */
    @media (max-width: 768px) {
        .stats-grid {
            grid-template-columns: 1fr;
            /* Stack cards vertically */
            gap: 1rem;
        }

        .charts-container {
            grid-template-columns: 1fr;
            /* Stack charts vertically */
        }

        .recent-table-container {
            padding: 1rem;
            overflow-x: auto;
            /* Enable horizontal scroll for table */
        }

        .filter-bar {
            padding-bottom: 0.5rem;
            margin-bottom: 1.5rem;
        }

        .stat-value {
            font-size: 1.5rem;
        }

        /* Adjust floating button position */
        button[onclick="openModal()"] {
            bottom: 1.5rem;
            right: 1.5rem;
            width: 50px;
            height: 50px;
            font-size: 1.5rem;
        }
    }
</style>

<div class="filter-bar"
    style="margin-bottom: 2rem; display: flex; gap: 0.5rem; overflow-x: auto; padding-bottom: 0.5rem;">
    <?php
    $filters = [
        'today' => 'Hari Ini',
        'week' => 'Minggu Ini',
        'month' => 'Bulan Ini',
        'all' => 'Semua'
    ];
    $currentFilter = $_GET['filter'] ?? 'all';
    ?>
    <?php foreach ($filters as $key => $label): ?>
        <a href="index.php?page=dashboard&filter=<?= $key ?>"
            class="filter-btn <?= $currentFilter === $key ? 'active' : '' ?>">
            <?= $label ?>
        </a>
    <?php endforeach; ?>
</div>

<style>
    .filter-btn {
        padding: 0.5rem 1rem;
        background: white;
        border: 1px solid #e5e7eb;
        border-radius: 99px;
        color: #4b5563;
        text-decoration: none;
        font-size: 0.9rem;
        font-weight: 500;
        transition: all 0.2s;
        white-space: nowrap;
    }

    .filter-btn:hover {
        background: #f9fafb;
        border-color: #d1d5db;
    }

    .filter-btn.active {
        background: var(--primary-gradient);
        color: white;
        border: none;
        box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.3);
    }
</style>

<div class="stats-grid">
    <div class="stat-card balance">
        <span class="stat-label">Total Saldo (<?= $filters[$currentFilter] ?>)</span>
        <span class="stat-value">Rp <?= number_format($balance, 2) ?></span>
        <span style="font-size: 0.8rem; color: #6b7280; font-weight: normal;">(Pemasukan - Pengeluaran)</span>
    </div>
    <div class="stat-card income">
        <span class="stat-label">Pemasukan</span>
        <span class="stat-value">+ Rp <?= number_format($totalIncome, 2) ?></span>
    </div>
    <div class="stat-card expense">
        <span class="stat-label">Pengeluaran</span>
        <span class="stat-value">- Rp <?= number_format($totalExpense, 2) ?></span>
    </div>
    <div class="stat-card profit" style="border-left: 4px solid #10b981;">
        <span class="stat-label">Profit / Komisi</span>
        <span class="stat-value" style="color:#10b981;">+ Rp <?= number_format($totalProfit, 2) ?></span>
    </div>
</div>

<div class="charts-container">
    <div class="chart-box">
        <div class="section-title">Cash Flow</div>
        <canvas id="cashFlowChart"></canvas>
    </div>
    <div class="chart-box">
        <div class="section-title">Saldo per Bank</div>
        <div class="bank-list">
            <?php foreach ($banks as $bank): ?>
                <div class="bank-item">
                    <span class="bank-info"><?= htmlspecialchars($bank['name']) ?></span>
                    <span class="bank-balance">Rp <?= number_format($bank['balance'], 2) ?></span>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<div class="recent-table-container">
    <div class="section-title">Transaksi Terakhir</div>
    <table>
        <thead>
            <tr>
                <th>TANGGAL</th>
                <th>BANK</th>
                <th>KATEGORI</th>
                <th>KETERANGAN</th>
                <th>JUMLAH</th>
                <th>STATUS</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($recentTransactions as $t): ?>
                <tr>
                    <td><?= date('d M Y H:i', strtotime($t['transaction_date'])) ?></td>
                    <td><?= htmlspecialchars($t['bank_name']) ?></td>
                    <td><?= htmlspecialchars($t['category_name'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($t['description']) ?></td>
                    <td style="font-weight:600">Rp <?= number_format($t['amount'], 2) ?></td>
                    <td>
                        <span class="badge badge-<?= $t['transaction_type'] ?>">
                            <?= $t['transaction_type'] === 'credit' ? 'Masuk' : 'Keluar' ?>
                        </span>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    const ctx = document.getElementById('cashFlowChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Total'],
            datasets: [
                {
                    label: 'Pemasukan',
                    data: [<?= $totalIncome ?>],
                    backgroundColor: '#10b981',
                    borderRadius: 10
                },
                {
                    label: 'Pengeluaran',
                    data: [<?= $totalExpense ?>],
                    backgroundColor: '#ef4444',
                    borderRadius: 10
                }
            ]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'bottom' } },
            scales: { y: { beginAtZero: true } }
        }
    });
</script>

<!-- Floating Action Button -->
<button onclick="openModal()" style="
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    background: var(--primary-gradient);
    color: white;
    width: 60px;
    height: 60px;
    border-radius: 50%;
    border: none;
    box-shadow: 0 4px 15px rgba(79, 70, 229, 0.4);
    font-size: 2rem;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: transform 0.2s;
    z-index: 100;
">+</button>

<!-- Transaction Modal -->
<div id="trxModal" style="
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    backdrop-filter: blur(4px);
    z-index: 1000;
    align-items: center;
    justify-content: center;
">
    <div style="
        background: white;
        padding: 2rem;
        border-radius: 24px;
        width: 100%;
        max-width: 500px;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        position: relative;
        animation: slideUp 0.3s ease-out;
    ">
        <button onclick="closeModal()"
            style="position: absolute; top: 1.5rem; right: 1.5rem; background: none; border: none; font-size: 1.5rem; cursor: pointer;">&times;</button>

        <h2 style="margin-top: 0; margin-bottom: 1.5rem; color: #111827;">Catat Transaksi</h2>

        <form method="POST" action="index.php?page=transactions/create" style="display: grid; gap: 1rem;">
            <div>
                <label
                    style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Rekening</label>
                <select name="account_id" required
                    style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                    <?php if (!empty($accounts)):
                        foreach ($accounts as $acc): ?>
                            <option value="<?= $acc['id'] ?>"><?= htmlspecialchars($acc['bank_name']) ?> -
                                <?= htmlspecialchars($acc['account_number']) ?></option>
                        <?php endforeach; endif; ?>
                </select>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                <div>
                    <label
                        style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Kategori</label>
                    <select name="category_id"
                        style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                        <?php if (!empty($categories)):
                            foreach ($categories as $cat): ?>
                                <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                            <?php endforeach; endif; ?>
                    </select>
                </div>
                <div>
                    <label
                        style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Jenis</label>
                    <select name="type" required
                        style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                        <option value="debit">Pengeluaran</option>
                        <option value="credit">Pemasukan</option>
                    </select>
                </div>
            </div>

            <div>
                <label style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Jumlah
                    (Rp)</label>
                <input type="number" name="amount" required placeholder="0"
                    style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
            </div>

            <div>
                <label style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Waktu</label>
                <input type="datetime-local" name="transaction_date" value="<?= date('Y-m-d\TH:i') ?>"
                    style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
            </div>

            <div>
                <label
                    style="display: block; font-weight: 500; margin-bottom: 0.5rem; font-size: 0.9rem;">Keterangan</label>
                <input type="text" name="description" placeholder="Contoh: Bayar Listrik"
                    style="width: 100%; padding: 0.75rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
            </div>

            <button type="submit"
                style="margin-top: 1rem; padding: 1rem; border-radius: 12px; border: none; background: var(--primary-gradient); color: white; font-weight: 600; font-size: 1rem; cursor: pointer;">
                Simpan Transaksi
            </button>
        </form>
    </div>
</div>

<script>
    function openModal() {
        const modal = document.getElementById('trxModal');
        modal.style.display = 'flex';
    }
    function closeModal() {
        const modal = document.getElementById('trxModal');
        modal.style.display = 'none';
    }
    window.onclick = function (event) {
        const modal = document.getElementById('trxModal');
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>

<style>
    @keyframes slideUp {
        from {
            transform: translateY(20px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>

<?php include __DIR__ . '/layout/footer.php'; ?>
```