<?php
$pageTitle = 'Riwayat Transaksi';
$tab = $_GET['tab'] ?? 'bank';
include __DIR__ . '/layout/header.php';
?>
<style>
    @media (max-width: 768px) {
        details form > div {
            grid-template-columns: 1fr 1fr !important;
        }
        
        summary {
            font-size: 0.85rem;
            padding: 0.5rem 0.75rem !important;
        }
    }
    
    details summary::-webkit-details-marker {
        display: none;
    }
    
    details[open] summary::after {
        content: " ▲";
        font-size: 0.7rem;
        opacity: 0.5;
    }
    
    details:not([open]) summary::after {
        content: " ▼";
        font-size: 0.7rem;
        opacity: 0.5;
    }
</style>

<div class="card"
    style="background: white; padding: 1.5rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">

    <!-- Tab Navigation -->
    <div style="display:flex; gap:1rem; margin-bottom:1.5rem; border-bottom:1px solid #e5e7eb;">
        <a href="index.php?page=history&tab=bank"
            style="padding:0.75rem 1.5rem; text-decoration:none; font-weight:600; border-bottom:2px solid <?= $tab === 'bank' ? '#4f46e5' : 'transparent' ?>; color: <?= $tab === 'bank' ? '#4f46e5' : '#6b7280' ?>;">
            Mutasi Bank & E-Wallet
        </a>
        <a href="index.php?page=history&tab=ppob"
            style="padding:0.75rem 1.5rem; text-decoration:none; font-weight:600; border-bottom:2px solid <?= $tab === 'ppob' ? '#4f46e5' : 'transparent' ?>; color: <?= $tab === 'ppob' ? '#4f46e5' : '#6b7280' ?>;">
            PPOB (Pulsa/Listrik)
        </a>
    </div>

    <!-- Compact Filter -->
    <details style="background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; margin-bottom: 1.5rem;">
        <summary
            style="padding: 0.625rem 1rem; cursor: pointer; font-weight: 500; color: #4f46e5; user-select: none; font-size: 0.875rem;">
            🔍 Filter
        </summary>

        <form method="GET" action="index.php" style="padding: 0.75rem 1rem; border-top: 1px solid #e5e7eb;">
            <input type="hidden" name="page" value="history">
            <input type="hidden" name="tab" value="<?= $tab ?>">

            <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 0.5rem; margin-bottom: 0.5rem;">
                <input type="date" name="start_date" value="<?= $_GET['start_date'] ?? '' ?>" placeholder="Dari"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem;">
                <input type="date" name="end_date" value="<?= $_GET['end_date'] ?? '' ?>" placeholder="Sampai"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem;">

                <select name="bank_id"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                    <option value="">Bank</option>
                    <?php foreach ($banks as $bank): ?>
                        <option value="<?= $bank['id'] ?>" <?= ($_GET['bank_id'] ?? '') == $bank['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($bank['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <select name="user_id"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                    <option value="">Eksekutor</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?= $user['id'] ?>" <?= ($_GET['user_id'] ?? '') == $user['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($user['full_name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div
                style="display: grid; grid-template-columns: repeat(<?= $tab === 'ppob' ? '5' : '4' ?>, 1fr); gap: 0.5rem; margin-bottom: 0.5rem;">
                <select name="transaction_type"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                    <option value="">Tipe</option>
                    <option value="credit" <?= ($_GET['transaction_type'] ?? '') == 'credit' ? 'selected' : '' ?>>Masuk
                    </option>
                    <option value="debit" <?= ($_GET['transaction_type'] ?? '') == 'debit' ? 'selected' : '' ?>>Keluar
                    </option>
                </select>

                <select name="status"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                    <option value="">Status</option>
                    <option value="success" <?= ($_GET['status'] ?? '') == 'success' ? 'selected' : '' ?>>Success</option>
                    <option value="pending" <?= ($_GET['status'] ?? '') == 'pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="failed" <?= ($_GET['status'] ?? '') == 'failed' ? 'selected' : '' ?>>Failed</option>
                </select>

                <select name="category_id"
                    style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                    <option value="">Kategori</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?= $cat['id'] ?>" <?= ($_GET['category_id'] ?? '') == $cat['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($cat['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <?php if ($tab === 'ppob'): ?>
                    <select name="service_id"
                        style="padding: 0.375rem 0.5rem; border-radius: 4px; border: 1px solid #d1d5db; font-size: 0.8rem; background: white;">
                        <option value="">Produk</option>
                        <?php foreach ($services as $svc): ?>
                            <option value="<?= $svc['id'] ?>" <?= ($_GET['service_id'] ?? '') == $svc['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($svc['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>

                <button type="submit"
                    style="padding: 0.375rem 0.75rem; border-radius: 4px; border: none; background: #4f46e5; color: white; cursor: pointer; font-weight: 500; font-size: 0.8rem;">
                    Terapkan
                </button>

                <a href="index.php?page=history&tab=<?= $tab ?>"
                    style="padding: 0.375rem 0.75rem; border-radius: 4px; border: 1px solid #d1d5db; background: white; color: #6b7280; text-decoration: none; display: inline-block; font-weight: 500; font-size: 0.8rem; text-align: center;">
                    Reset
                </a>
            </div>
        </form>
    </details>

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="border-bottom: 2px solid #f3f4f6; text-align: left;">
                    <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Waktu</th>
                    <?php if ($tab === 'bank'): ?>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Keterangan /
                            Kategori</th>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Tipe</th>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Jumlah</th>
                    <?php else: ?>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Produk</th>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Tujuan (ID/HP)</th>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Harga Beli</th>
                        <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Profit</th>
                    <?php endif; ?>
                    <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Eksekutor</th>
                    <th style="padding: 1rem; color: #6b7280; font-size: 0.85rem; font-weight: 600;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $trx): ?>
                    <tr style="border-bottom: 1px solid #f9fafb;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: 500; font-size: 0.9rem;">
                                <?= date('d M Y', strtotime($trx['transaction_date'])) ?>
                            </div>
                            <div style="font-size: 0.75rem; color: #6b7280;">
                                <?= date('H:i:s', strtotime($trx['transaction_date'])) ?> WIB
                            </div>
                        </td>

                        <?php if ($tab === 'bank'): ?>
                            <td style="padding: 1rem;">
                                <div style="font-weight: 500; color: #111827;"><?= htmlspecialchars($trx['description']) ?>
                                </div>
                                <div style="font-size: 0.8rem; color: #9ca3af;">
                                    <?= htmlspecialchars($trx['category_name'] ?? 'Umum') ?>
                                    <?php if (isset($trx['service_name'])): ?>
                                        <span
                                            style="background:#e0e7ff; color:#4338ca; padding:2px 6px; border-radius:4px; font-size:0.7rem; margin-left:5px;">E-WALLET</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="padding: 1rem;">
                                <?php if ($trx['transaction_type'] == 'credit'): ?>
                                    <span
                                        style="color: #10b981; background: #d1fae5; padding: 4px 8px; border-radius: 99px; font-size: 0.75rem; font-weight: 600;">PEMASUKAN</span>
                                <?php else: ?>
                                    <span
                                        style="color: #ef4444; background: #fee2e2; padding: 4px 8px; border-radius: 99px; font-size: 0.75rem; font-weight: 600;">PENGELUARAN</span>
                                <?php endif; ?>
                            </td>
                            <td
                                style="padding: 1rem; font-weight: 600; color: <?= $trx['transaction_type'] == 'credit' ? '#10b981' : '#ef4444' ?>;">
                                <?= $trx['transaction_type'] == 'credit' ? '+' : '-' ?> Rp
                                <?= number_format($trx['amount'], 0) ?>
                            </td>

                        <?php else: ?>
                            <td style="padding: 1rem;">
                                <div style="font-weight: 500;"><?= htmlspecialchars($trx['service_name']) ?></div>
                                <div style="font-size:0.8rem; color:#6b7280;"><?= htmlspecialchars($trx['service_category']) ?>
                                </div>
                            </td>
                            <td style="padding: 1rem; font-family:monospace;"><?= htmlspecialchars($trx['customer_phone']) ?>
                            </td>
                            <td style="padding: 1rem; color:#ef4444;">Rp <?= number_format($trx['amount'], 0) ?></td>
                            <td style="padding: 1rem; color:#10b981;">+ Rp <?= number_format($trx['profit_amount'], 0) ?></td>
                        <?php endif; ?>

                        <td style="padding: 1rem; font-size: 0.85rem; color: #4b5563;">
                            <?= htmlspecialchars($trx['executor_name'] ?? '-') ?>
                        </td>

                        <td style="padding: 1rem;">
                            <?php
                            $statusColors = [
                                'success' => ['bg' => '#d1fae5', 'text' => '#065f46'],
                                'pending' => ['bg' => '#fef3c7', 'text' => '#92400e'],
                                'failed' => ['bg' => '#fee2e2', 'text' => '#b91c1c']
                            ];
                            $s = $trx['status'] ?? 'pending';
                            $color = $statusColors[$s] ?? $statusColors['pending'];
                            ?>
                            <span
                                style="display: inline-block; padding: 0.25rem 0.75rem; border-radius: 9999px; font-size: 0.75rem; font-weight: 600; background-color: <?= $color['bg'] ?>; color: <?= $color['text'] ?>; text-transform: uppercase;">
                                <?= $s ?>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($transactions)): ?>
                    <tr>
                        <td colspan="6" style="padding: 2rem; text-align: center; color: #9ca3af;">Tidak ada data ditemukan.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/layout/footer.php'; ?>