<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>PPOB Banyuwangi Reload - Professional Banking</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #4f46e5 0%, #3b82f6 100%);
            --secondary-gradient: linear-gradient(135deg, #10b981 0%, #059669 100%);
            --danger-gradient: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            --background-color: #f3f4f6;
            --card-bg: rgba(255, 255, 255, 0.8);
            --text-color: #1f2937;
            --glass-border: 1px solid rgba(255, 255, 255, 0.4);
        }

        *,
        *::before,
        *::after {
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--background-color);
            margin: 0;
            color: var(--text-color);
            line-height: 1.6;
            min-height: 100vh;
        }

        .main-content {
            margin-left: 240px;
            flex: 1;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            background-image:
                radial-gradient(at 100% 0%, hsla(249, 100%, 96%, 1) 0px, transparent 50%),
                radial-gradient(at 0% 0%, hsla(225, 100%, 96%, 1) 0px, transparent 50%);
            transition: margin-left 0.3s ease;
        }

        @media (max-width: 768px) {
            .main-content {
                margin-left: 0 !important;
                padding-bottom: 80px;
            }
        }

        .top-bar {
            padding: 1.5rem 2.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(255, 255, 255, 0.6);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.03);
            position: sticky;
            top: 0;
            z-index: 50;
        }

        .page-title h1 {
            margin: 0;
            font-size: 1.6rem;
            font-weight: 700;
            color: #111827;
            letter-spacing: -0.025em;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 1rem;
            background: white;
            padding: 0.5rem 1rem;
            border-radius: 99px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            border: 1px solid #f3f4f6;
        }

        .clock-display {
            background: linear-gradient(135deg, #4f46e5 0%, #3b82f6 100%);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 99px;
            font-size: 0.85rem;
            font-weight: 500;
            box-shadow: 0 4px 6px rgba(79, 70, 229, 0.2);
            margin-right: 1rem;
        }

        .avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary-gradient);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            box-shadow: 0 4px 10px rgba(79, 70, 229, 0.2);
        }

        .content-wrapper {
            padding: 2.5rem;
            flex: 1;
            width: 100%;
            box-sizing: border-box;
            margin: 0;
        }

        /* Premium Card Style */
        .card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.02);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .card:hover {
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.05);
        }

        /* Modern Inputs */
        input[type="text"],
        input[type="number"],
        input[type="password"],
        input[type="email"],
        input[type="url"],
        select {
            transition: border-color 0.2s, box-shadow 0.2s;
        }

        input:focus,
        select:focus {
            outline: none;
            border-color: #6366f1 !important;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1) !important;
        }

        /* Modern Buttons */
        button,
        .btn {
            transition: opacity 0.2s, transform 0.1s;
        }

        button:active,
        .btn:active {
            transform: scale(0.98);
        }

        /* Table Styling */
        th {
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        td {
            font-size: 0.95rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .content-wrapper>* {
            animation: fadeIn 0.4s ease-out;
        }

        /* Mobile Bottom Navigation */
        .bottom-nav {
            display: none;
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(20px);
            border-top: 1px solid #e5e7eb;
            z-index: 1000;
            padding-bottom: env(safe-area-inset-bottom);
            box-shadow: 0 -4px 6px -1px rgba(0, 0, 0, 0.05);
        }

        .bottom-nav-items {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 0.5rem;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #6b7280;
            font-size: 0.75rem;
            gap: 0.25rem;
            padding: 0.5rem;
            border-radius: 12px;
            transition: all 0.2s;
        }

        .nav-item.active {
            color: #4f46e5;
            background: rgba(79, 70, 229, 0.05);
        }

        .nav-item span {
            font-size: 1.25rem;
        }

        @media (max-width: 768px) {
            .bottom-nav {
                display: block;
            }

            .main-content {
                padding-bottom: 80px;
                /* Space for bottom nav */
                margin-left: 0;
                /* Full width */
            }

            .sidebar {
                display: none;
                /* Hide sidebar completely on mobile */
            }

            /* Hide the mobile hamburger since we use bottom nav now */
            button[onclick*="toggleSidebar"] {
                display: none !important;
            }
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .main-content {
                margin-left: 0;
            }

            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease-in-out;
                z-index: 100;
                position: fixed;
                height: 100%;
                box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .top-bar {
                padding: 1rem 1.5rem;
            }

            .page-title h1 {
                font-size: 1.25rem;
            }

            .content-wrapper {
                padding: 1.5rem;
            }

            .mobile-menu-btn {
                display: block !important;
            }

            .user-profile span {
                display: none;
                /* Hide admin name on mobile */
            }

            /* Overlay when sidebar open */
            #sidebarOverlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.5);
                backdrop-filter: blur(2px);
                z-index: 90;
            }

            #sidebarOverlay.active {
                display: block;
            }
        }
    </style>
</head>

<body>
    <!-- Mobile Overlay -->
    <div id="sidebarOverlay" onclick="toggleSidebar()"></div>

    <!-- Sidebar -->
    <?php include __DIR__ . '/sidebar.php'; ?>

    <main class="main-content">
        <header class="top-bar">
            <div style="display:flex; align-items:center; gap:1rem;">
                <button class="mobile-menu-btn" onclick="toggleSidebar()"
                    style="display:none; background:none; border:none; font-size:1.5rem; cursor:pointer; color:var(--text-color);">
                    ☰
                </button>
                <div class="page-title">
                    <h1><?= isset($pageTitle) ? $pageTitle : 'Dashboard' ?></h1>
                </div>
            </div>
            <div style="display: flex; align-items: center; gap: 1rem;">
                <div class="clock-display" id="liveClock"></div>
                <div class="user-profile">
                    <span><?= $_SESSION['username'] ?? 'Admin' ?></span>
                    <div class="avatar"><?= strtoupper(substr($_SESSION['username'] ?? 'A', 0, 1)) ?></div>
                </div>
            </div>
        </header>
        <div class="content-wrapper">

            <script>
                function updateClock() {
                    const now = new Date();
                    const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
                    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];

                    const day = days[now.getDay()];
                    const date = now.getDate();
                    const month = months[now.getMonth()];
                    const hours = String(now.getHours()).padStart(2, '0');
                    const minutes = String(now.getMinutes()).padStart(2, '0');
                    const seconds = String(now.getSeconds()).padStart(2, '0');

                    document.getElementById('liveClock').textContent =
                        `${day}, ${date} ${month} • ${hours}:${minutes}:${seconds} WIB`;
                }

                updateClock();
                setInterval(updateClock, 1000);

                function toggleSidebar() {
                    document.getElementById('sidebarContainer').classList.toggle('active');
                    document.getElementById('sidebarOverlay').classList.toggle('active');
                }
            </script>