<!-- Sidebar -->
<aside class="sidebar" id="sidebarContainer">
    <div class="brand">
        <div class="logo-icon">💰</div>
        <h2>PPOB Banyuwangi Reload</h2>
    </div>

    <nav class="nav-links">
        <div class="nav-section">Menu Utama</div>
        <a href="index.php?page=dashboard" class="<?= $page === 'dashboard' ? 'active' : '' ?>">
            <span class="icon">📊</span> Dashboard
        </a>
        <a href="index.php?page=history" class="<?= strpos($page, 'history') === 0 ? 'active' : '' ?>">
            <span class="icon">📜</span> Riwayat
        </a>
        <a href="index.php?page=analytics" class="<?= strpos($page, 'analytics') === 0 ? 'active' : '' ?>">
            <span class="icon">📈</span> Data Analitik
        </a>

        <div class="nav-section">Keuangan</div>
        <a href="index.php?page=banking" class="<?= strpos($page, 'banking') === 0 ? 'active' : '' ?>">
            <span class="icon">🏦</span> Perbankan
        </a>

        <div class="nav-section">Pengaturan</div>
        <a href="index.php?page=settings" class="<?= strpos($page, 'settings') === 0 ? 'active' : '' ?>">
            <span class="icon">⚙️</span> Pengaturan
        </a>

        <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
            <div class="nav-section">Admin</div>
            <a href="index.php?page=admin/services" class="<?= strpos($page, 'admin/services') === 0 ? 'active' : '' ?>">
                <span class="icon">🏷️</span> Produk & Fee
            </a>
            <a href="index.php?page=admin/users" class="<?= strpos($page, 'admin/users') === 0 ? 'active' : '' ?>">
                <span class="icon">👥</span> Kelola Agen
            </a>
            <a href="index.php?page=admin/audit" class="<?= strpos($page, 'admin/audit') === 0 ? 'active' : '' ?>">
                <span class="icon">🛡️</span> Audit Logs
            </a>
        <?php endif; ?>

        <div class="nav-section">Akun</div>
        <a href="index.php?page=profile" class="<?= strpos($page, 'profile') === 0 ? 'active' : '' ?>">
            <span class="icon">👤</span> Profil Saya
        </a>
        <a href="index.php?page=logout" style="color:#ef4444;">
            <span class="icon">🚪</span> Logout
        </a>
    </nav>
</aside>

<style>
    .sidebar {
        width: 240px;
        background: rgba(255, 255, 255, 0.85);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        height: 100vh;
        position: fixed;
        top: 0;
        left: 0;
        border-right: 1px solid rgba(0, 0, 0, 0.05);
        display: flex;
        flex-direction: column;
        z-index: 120;
        transition: transform 0.3s ease;
        padding: 2rem 1.5rem;
    }

    /* Hide sidebar on tablet/mobile */
    @media (max-width: 768px) {
        .sidebar {
            transform: translateX(-100%);
            display: none;
        }
    }

    .brand {
        display: flex;
        align-items: center;
        gap: 1rem;
        margin-bottom: 3rem;
    }

    .logo-icon {
        font-size: 2rem;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .brand h2 {
        margin: 0;
        font-size: 1.5rem;
        color: #1f2937;
    }

    .nav-links {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .nav-links a {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1rem 1.5rem;
        border-radius: 16px;
        text-decoration: none;
        color: #4b5563;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .nav-links a:hover {
        background: rgba(255, 255, 255, 0.5);
        transform: translateX(5px);
    }

    .nav-links a.active {
        background: var(--primary-gradient);
        color: white;
        box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.3);
    }

    .nav-links a.active .icon {
        filter: brightness(0) invert(1);
    }

    .nav-section {
        margin-top: 1.5rem;
        padding-left: 1rem;
        font-size: 0.75rem;
        color: #9ca3af;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }
</style>