<?php
$pageTitle = 'Beli ' . htmlspecialchars($_GET['category']);
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); max-width: 500px; margin: 0 auto;">
    <h2 style="margin-top:0;">Form Pembelian</h2>

    <form method="POST" action="index.php?page=ppob/checkout">
        <div style="margin-bottom: 1rem;">
            <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Nomor Pelanggan / HP</label>
            <input type="text" name="customer_phone" required placeholder="08123456789"
                style="width:100%; padding:0.875rem; border:1px solid #d1d5db; border-radius:12px;">
        </div>

        <div style="margin-bottom: 1rem;">
            <label style="display:block; margin-bottom:0.5rem; font-weight:500;">Pilih Produk</label>
            <select name="service_id" required
                style="width:100%; padding:0.875rem; border:1px solid #d1d5db; border-radius:12px; background:white;">
                <option value="" disabled selected>Pilih Layanan</option>
                <?php foreach ($services as $svc): ?>
                    <option value="<?= $svc['id'] ?>">
                        <?= htmlspecialchars($svc['name']) ?> - Rp
                        <?= number_format($svc['base_price'] + $svc['admin_fee'], 0) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <small style="color:#6b7280; display:block; margin-top:0.25rem;">*Harga sudah termasuk biaya admin.</small>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label style="display:block; margin-bottom:0.5rem; font-weight:500;">PIN Transaksi</label>
            <input type="password" name="pin" required placeholder="••••••" maxlength="6" inputmode="numeric"
                style="width:100%; padding:0.875rem; border:1px solid #d1d5db; border-radius:12px;">
        </div>

        <button type="submit"
            style="width:100%; padding:1rem; background: var(--primary-gradient); color:white; border:none; border-radius:12px; font-weight:600; cursor:pointer;">
            Bayar Sekarang
        </button>
    </form>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>