<?php
$pageTitle = 'Profil Saya';
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); max-width:600px; margin:0 auto;">
    <h2 style="margin-top:0; margin-bottom:1.5rem;">Pengaturan Akun</h2>

    <?php if (isset($_GET['success'])): ?>
        <div style="background:#d1fae5; color:#065f46; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">
            Profil berhasil diperbarui!
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=profile/update">
        <div style="margin-bottom:1.5rem;">
            <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Username</label>
            <input type="text" value="<?= htmlspecialchars($user['username']) ?>" disabled
                style="width:100%; padding:0.75rem; border:1px solid #e5e7eb; border-radius:8px; background:#f9fafb; color:#6b7280;">
        </div>

        <div style="margin-bottom:1.5rem;">
            <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Nama Lengkap</label>
            <input type="text" value="<?= htmlspecialchars($user['full_name']) ?>" disabled
                style="width:100%; padding:0.75rem; border:1px solid #e5e7eb; border-radius:8px; background:#f9fafb; color:#6b7280;">
        </div>

        <hr style="border:none; border-top:1px solid #e5e7eb; margin:2rem 0;">

        <div style="margin-bottom:1.5rem;">
            <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Ganti Password Baru</label>
            <input type="password" name="password" placeholder="Kosongkan jika tidak ingin mengganti"
                style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
        </div>

        <div style="margin-bottom:2rem;">
            <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Ganti PIN Baru (6 Digit)</label>
            <input type="number" name="pin" placeholder="Kosongkan jika tidak ingin mengganti" maxlength="6"
                style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
        </div>

        <button type="submit"
            style="width:100%; background:#4f46e5; color:white; padding:0.75rem; border:none; border-radius:8px; font-weight:600; cursor:pointer;">
            Simpan Perubahan
        </button>
    </form>
</div>

<style>
    @media (max-width: 600px) {
        .card {
            padding: 1.5rem !important;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>