<?php
// Fetch transaction details
$trxId = $_GET['id'];
$stmt = $pdo->prepare("
    SELECT t.*, s.name as service_name, u.full_name as agent_name 
    FROM transactions t 
    JOIN services s ON t.service_id = s.id 
    JOIN users u ON t.user_id = u.id 
    WHERE t.id = :id
");
$stmt->execute([':id' => $trxId]);
$trx = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$trx)
    die("Transaksi tidak ditemukan.");

// Calculate Total (Amount deducted from agent + Admin Fee charged to customer... wait.)
// In checkout(): amount = totalCost (base + commission? No, base). 
// Actually, let's look at checkout logic:
// amount = base_price. 
// Receipt should show: Price to Customer = base_price + admin_fee.
// Agent Margin = commission.
// Let's assume 'amount' stored in DB is the cost to agent.
// But we need to show the price to customer on receipt.
$priceToCustomer = $trx['amount'] + $trx['fee_amount'];
?>
<!DOCTYPE html>
<html>

<head>
    <title>Struk Transaksi #<?= $trx['id'] ?></title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            background: #eee;
            display: flex;
            justify-content: center;
            padding-top: 2rem;
        }

        .receipt {
            background: white;
            width: 300px;
            padding: 20px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .center {
            text-align: center;
        }

        .bold {
            font-weight: bold;
        }

        .line {
            border-bottom: 1px dashed #000;
            margin: 10px 0;
        }

        .row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            font-size: 0.9rem;
        }

        .btn-group {
            margin-top: 20px;
            display: flex;
            gap: 10px;
        }

        .btn {
            flex: 1;
            padding: 10px;
            border: none;
            cursor: pointer;
            font-weight: bold;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            text-align: center;
            display: block;
        }

        .btn-print {
            background: #374151;
        }

        .btn-home {
            background: #4f46e5;
        }

        @media print {
            body {
                background: white;
                padding: 0;
            }

            .receipt {
                box-shadow: none;
                width: 100%;
            }

            .btn-group {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="receipt">
        <div class="center">
            <h2 style="margin:0;">PPOB BANYUWANGI RELOAD</h2>
            <p style="margin:5px 0; font-size:0.8rem;">Agen: <?= htmlspecialchars($trx['agent_name']) ?></p>
            <p style="margin:0; font-size:0.8rem;"><?= date('d/m/Y H:i', strtotime($trx['transaction_date'])) ?></p>
        </div>

        <div class="line"></div>

        <div class="center bold" style="margin-bottom: 10px;"><?= htmlspecialchars($trx['service_name']) ?></div>

        <div class="row">
            <span>No. Tujuan</span>
            <span><?= htmlspecialchars($trx['customer_phone']) ?></span>
        </div>
        <div class="row">
            <span>Status</span>
            <span>SUKSES</span>
        </div>
        <div class="row">
            <span>Ref</span>
            <span>TRX-<?= $trx['id'] ?></span>
        </div>

        <div class="line"></div>

        <div class="row bold" style="font-size: 1.1rem;">
            <span>TOTAL</span>
            <span>Rp <?= number_format($priceToCustomer, 0, ',', '.') ?></span>
        </div>

        <div class="line"></div>
        <div class="center" style="font-size: 0.8rem;">
            Terima Kasih<br>
            Simpan struk ini sebagai bukti pembayaran sah.
        </div>

        <div class="btn-group">
            <button onclick="window.print()" class="btn btn-print">🖨️ Cetak</button>
            <a href="index.php?page=dashboard" class="btn btn-home">🏠 Menu</a>
        </div>
    </div>
</body>

</html>