<?php
$pageTitle = 'Kelola Kategori';
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); max-width: 800px; margin: 0 auto;">
    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:1.5rem;">
        <div>
            <h2 style="margin:0;">Kategori Transaksi</h2>
            <p style="color:#6b7280; font-size:0.9rem; margin-top:0.25rem;">Atur kategori untuk pengelompokan transaksi.
            </p>
        </div>
        <a href="index.php?page=settings" style="text-decoration:none; color:#4b5563; font-weight:500;">
            &larr; Kembali
        </a>
    </div>

    <!-- Alert Messages -->
    <?php if (isset($_GET['success']) && $_GET['success'] == 'created'): ?>
        <div style="background:#d1fae5; color:#065f46; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">Kategori
            berhasil ditambahkan.</div>
    <?php elseif (isset($_GET['success']) && $_GET['success'] == 'deleted'): ?>
        <div style="background:#fee2e2; color:#b91c1c; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">Kategori
            berhasil dihapus.</div>
    <?php elseif (isset($_GET['error']) && $_GET['error'] == 'in_use'): ?>
        <div style="background:#fff7ed; color:#9a3412; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">Gagal
            menghapus: Kategori sedang digunakan dalam transaksi.</div>
    <?php endif; ?>

    <!-- Add Form -->
    <form method="POST" action="index.php?page=settings/categories/create"
        style="display:flex; gap:1rem; margin-bottom:2rem; background:#f9fafb; padding:1.5rem; border-radius:12px;">
        <div style="flex:1;">
            <label style="display:block; font-weight:500; margin-bottom:0.5rem; font-size:0.9rem;">Nama Kategori
                Baru</label>
            <input type="text" name="name" required placeholder="Contoh: Hiburan"
                style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
        </div>
        <div style="display:flex; align-items:flex-end;">
            <button type="submit"
                style="padding:0.75rem 1.5rem; background:#4f46e5; color:white; border:none; border-radius:8px; font-weight:600; cursor:pointer;">
                + Tambah
            </button>
        </div>
    </form>

    <!-- List -->
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="border-bottom: 2px solid #f3f4f6; text-align:left;">
                <th style="padding:1rem;">Nama Kategori</th>
                <th style="padding:1rem; width:100px; text-align:center;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categories as $cat): ?>
                <tr style="border-bottom: 1px solid #f3f4f6;">
                    <td style="padding:1rem; font-weight:500;"><?= htmlspecialchars($cat['name']) ?></td>
                    <td style="padding:1rem; text-align:center;">
                        <a href="index.php?page=settings/categories/delete&id=<?= $cat['id'] ?>"
                            onclick="return confirm('Hapus kategori ini?');"
                            style="color:#ef4444; text-decoration:none; font-weight:600; font-size:0.9rem;">
                            Hapus
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            <?php if (empty($categories)): ?>
                <tr>
                    <td colspan="2" style="padding:2rem; text-align:center; color:#9ca3af;">Belum ada kategori.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>