<?php
$pageTitle = 'Pengaturan & Data';
include __DIR__ . '/../layout/header.php';
?>

<?php if (isset($_GET['success'])): ?>
    <div style="background: #ecfdf5; color: #047857; padding: 1rem; border-radius: 12px; margin-bottom: 2rem;">
        <?php if ($_GET['success'] == 'imported'): ?>
            ✓ Data transaksi berhasil diimpor.
        <?php elseif ($_GET['success'] == 'reset'): ?>
            ✓ Database telah direset.
        <?php endif; ?>
    </div>
<?php endif; ?>

<div
    style="display: grid; gap: 1.5rem; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); margin-bottom:2rem;">

    <!-- Categories -->
    <a href="index.php?page=settings/categories"
        style="text-decoration:none; color:inherit; display:block; height:100%;">
        <div style="background:white; padding:1.5rem; border-radius:16px; border:1px solid #e5e7eb; transition:all 0.2s; height:100%; display:flex; flex-direction:column; box-sizing:border-box;"
            onmouseover="this.style.borderColor='#4f46e5'; this.style.boxShadow='0 4px 6px -1px rgba(79, 70, 229, 0.1)';"
            onmouseout="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
            <div
                style="width:40px; height:40px; background:#e0e7ff; border-radius:10px; display:flex; align-items:center; justify-content:center; margin-bottom:1rem; color:#4338ca; font-size:1.2rem;">
                🏷️
            </div>
            <h3 style="margin:0 0 0.5rem 0; font-size:1.1rem;">Kategori Transaksi</h3>
            <p style="margin:0; color:#6b7280; font-size:0.9rem;">Kelola kategori untuk pengelompokan transaksi.</p>
        </div>
    </a>

    <!-- API Integrations -->
    <a href="index.php?page=settings/integrations"
        style="text-decoration:none; color:inherit; display:block; height:100%;">
        <div style="background:white; padding:1.5rem; border-radius:16px; border:1px solid #e5e7eb; transition:all 0.2s; height:100%; display:flex; flex-direction:column; box-sizing:border-box;"
            onmouseover="this.style.borderColor='#4f46e5'; this.style.boxShadow='0 4px 6px -1px rgba(79, 70, 229, 0.1)';"
            onmouseout="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
            <div
                style="width:40px; height:40px; background:#ecfdf5; border-radius:10px; display:flex; align-items:center; justify-content:center; margin-bottom:1rem; color:#047857; font-size:1.2rem;">
                🔌
            </div>
            <h3 style="margin:0 0 0.5rem 0; font-size:1.1rem;">Integrasi API</h3>
            <p style="margin:0; color:#6b7280; font-size:0.9rem;">Atur koneksi ke Otomax, Digiflazz, dan Bank.</p>
        </div>
    </a>

    <!-- Bank Management -->
    <a href="index.php?page=banks" style="text-decoration:none; color:inherit; display:block; height:100%;">
        <div style="background:white; padding:1.5rem; border-radius:16px; border:1px solid #e5e7eb; transition:all 0.2s; height:100%; display:flex; flex-direction:column; box-sizing:border-box;"
            onmouseover="this.style.borderColor='#4f46e5'; this.style.boxShadow='0 4px 6px -1px rgba(79, 70, 229, 0.1)';"
            onmouseout="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
            <div
                style="width:40px; height:40px; background:#fee2e2; border-radius:10px; display:flex; align-items:center; justify-content:center; margin-bottom:1rem; color:#b91c1c; font-size:1.2rem;">
                🏦
            </div>
            <h3 style="margin:0 0 0.5rem 0; font-size:1.1rem;">Manajemen Bank</h3>
            <p style="margin:0; color:#6b7280; font-size:0.9rem;">Tambah atau ubah daftar bank dan rekening.</p>
        </div>
    </a>

</div>

<div style="display: grid; gap: 2rem; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));">
    <!-- Export/Import Card -->
    <div class="card"
        style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
        <h2 style="margin-top: 0; font-size: 1.25rem;">Backup & Restore</h2>
        <p style="color: #6b7280; font-size: 0.9rem; margin-bottom: 1.5rem;">Unduh data transaksi Anda atau pulihkan
            dari file CSV.</p>

        <div style="margin-bottom: 2rem;">
            <a href="index.php?page=settings/export"
                style="display: block; width: 100%; padding: 1rem; text-align: center; background: #f3f4f6; color: #374151; border-radius: 12px; text-decoration: none; font-weight: 500; border: 1px solid #e5e7eb;">
                📥 Export Data (CSV)
            </a>
        </div>

        <hr style="border: 0; border-top: 1px solid #f3f4f6; margin-bottom: 1.5rem;">

        <form action="index.php?page=settings/import" method="POST" enctype="multipart/form-data">
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 500; font-size: 0.9rem;">Import File
                CSV</label>
            <input type="file" name="csv_file" accept=".csv" required
                style="display: block; width: 100%; margin-bottom: 1rem; padding: 0.5rem; border: 1px solid #d1d5db; border-radius: 8px;">
            <button type="submit"
                style="width: 100%; padding: 1rem; background: var(--primary-gradient); color: white; border: none; border-radius: 12px; font-weight: 600; cursor: pointer;">
                📤 Import Data
            </button>
        </form>
    </div>

    <!-- Danger Zone Card -->
    <div class="card"
        style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); border: 1px solid #fee2e2;">
        <h2 style="margin-top: 0; font-size: 1.25rem; color: #b91c1c;">Danger Zone</h2>
        <p style="color: #6b7280; font-size: 0.9rem; margin-bottom: 1.5rem;">Hati-hati, tindakan ini tidak dapat
            dibatalkan.</p>

        <form action="index.php?page=settings/reset" method="POST"
            onsubmit="return confirm('APAKAH ANDA YAKIN? Semua data transaksi akan dihapus permanen!');">
            <button type="submit"
                style="width: 100%; padding: 1rem; background: #fee2e2; color: #b91c1c; border: 1px solid #fecaca; border-radius: 12px; font-weight: 600; cursor: pointer;">
                ⚠️ Reset Database (Hapus Semua)
            </button>
        </form>
        <p style="text-align: center; font-size: 0.8rem; color: #9ca3af; margin-top: 1rem;">
            Ini akan menghapus tabel transaksi dan logs. Data Bank dan Akun akan tetap aman.
        </p>
    </div>
</div>

<style>
    @media (max-width: 600px) {
        div[style*="grid-template-columns"] {
            grid-template-columns: 1fr !important;
        }

        .card {
            padding: 1.5rem !important;
        }
    }
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>