<?php
$pageTitle = 'Integrasi API';
include __DIR__ . '/../layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); max-width: 600px; margin: 0 auto;">
    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:1.5rem;">
        <div>
            <h2 style="margin:0;">Integrasi Aplikasi</h2>
            <p style="color:#6b7280; font-size:0.9rem; margin-top:0.25rem;">Atur koneksi ke layanan pihak ketiga
                (Otomax, Digiflazz, dll).</p>
        </div>
        <a href="index.php?page=settings" style="text-decoration:none; color:#4b5563; font-weight:500;">&larr;
            Kembali</a>
    </div>

    <?php if (isset($_GET['success'])): ?>
        <div style="background:#d1fae5; color:#065f46; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">
            Pengaturan API berhasil disimpan!
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=settings/integrations/update"
        style="display:flex; flex-direction:column; gap:1.5rem;">

        <!-- Otomax Section -->
        <div style="padding:1.5rem; border:1px solid #e5e7eb; border-radius:12px; background:#f9fafb;">
            <h3 style="margin-top:0; color:#4f46e5;">Otomax Integrasi</h3>
            <div style="margin-bottom:1rem;">
                <label style="display:block; font-weight:500; margin-bottom:0.5rem;">API URL Endpoint</label>
                <input type="text" name="otomax_url" value="<?= htmlspecialchars($settings['otomax_url'] ?? '') ?>"
                    placeholder="http://ip_otomax:port/api"
                    style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div>
                <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Secret Key / Password</label>
                <input type="text" name="otomax_key" value="<?= htmlspecialchars($settings['otomax_key'] ?? '') ?>"
                    placeholder="Secret Key"
                    style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
        </div>

        <!-- Digiflazz Section -->
        <div style="padding:1.5rem; border:1px solid #e5e7eb; border-radius:12px; background:#f9fafb;">
            <h3 style="margin-top:0; color:#0e7490;">Digiflazz Integrasi</h3>
            <div style="margin-bottom:1rem;">
                <label style="display:block; font-weight:500; margin-bottom:0.5rem;">Username</label>
                <input type="text" name="digiflazz_user"
                    value="<?= htmlspecialchars($settings['digiflazz_user'] ?? '') ?>" placeholder="Username Digiflazz"
                    style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
            <div>
                <label style="display:block; font-weight:500; margin-bottom:0.5rem;">API Key (Production/Dev)</label>
                <input type="text" name="digiflazz_key"
                    value="<?= htmlspecialchars($settings['digiflazz_key'] ?? '') ?>" placeholder="Digiflazz Key"
                    style="width:100%; padding:0.75rem; border:1px solid #d1d5db; border-radius:8px;">
            </div>
        </div>

        <button type="submit"
            style="width:100%; background:var(--primary-gradient); color:white; padding:1rem; border:none; border-radius:12px; font-weight:600; cursor:pointer;">
            Simpan Konfigurasi API
        </button>
    </form>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>