<?php
$pageTitle = 'Transaksi Baru';
include __DIR__ . '/layout/header.php';
?>

<div class="card"
    style="background: white; padding: 2rem; border-radius: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); max-width: 600px; margin: 0 auto;">
    <div style="margin-bottom: 2rem; text-align: center;">
        <h1 style="font-size: 1.5rem; color: #1f2937; margin: 0;">Catat Transaksi</h1>
        <p style="color: #6b7280; margin-top: 0.5rem;">Masukkan detail pemasukan atau pengeluaran</p>
    </div>

    <?php if (isset($_GET['success'])): ?>
        <div
            style="background: #ecfdf5; color: #047857; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem; text-align: center;">
            ✓ Transaksi berhasil disimpan
        </div>
    <?php endif; ?>

    <form method="POST" action="index.php?page=transactions/create" style="display: grid; gap: 1.25rem;">
        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="account_id" style="font-weight: 500; font-size: 0.9rem;">Rekening Bank</label>
            <select name="account_id" id="account_id" required
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                <option value="" disabled selected>Pilih Sumber Dana</option>
                <?php if (!empty($accounts)):
                    foreach ($accounts as $acc): ?>
                        <option value="<?= $acc['id'] ?>">
                            <?= htmlspecialchars($acc['bank_name']) ?> - <?= htmlspecialchars($acc['account_number']) ?>
                        </option>
                    <?php endforeach; endif; ?>
            </select>
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="category_id" style="font-weight: 500; font-size: 0.9rem;">Kategori</label>
            <select name="category_id" id="category_id"
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                <option value="" disabled selected>Pilih Kategori</option>
                <?php if (!empty($categories)):
                    foreach ($categories as $cat): ?>
                        <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                    <?php endforeach; endif; ?>
            </select>
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="amount" style="font-weight: 500; font-size: 0.9rem;">Jumlah (IDR)</label>
            <input type="number" step="0.01" name="amount" id="amount" placeholder="0.00" required
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="type" style="font-weight: 500; font-size: 0.9rem;">Jenis Transaksi</label>
            <select name="type" id="type" required
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
                <option value="debit">Pengeluaran (Debit)</option>
                <option value="credit">Pemasukan (Kredit)</option>
            </select>
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="transaction_date" style="font-weight: 500; font-size: 0.9rem;">Waktu Transaksi</label>
            <input type="datetime-local" name="transaction_date" id="transaction_date" required
                value="<?= date('Y-m-d\TH:i') ?>"
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="description" style="font-weight: 500; font-size: 0.9rem;">Keterangan</label>
            <textarea name="description" id="description" rows="3" placeholder="Contoh: Bayar tagihan internet"
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb; font-family: inherit;"></textarea>
        </div>

        <div style="display: flex; flex-direction: column; gap: 0.5rem;">
            <label for="external_ref" style="font-weight: 500; font-size: 0.9rem;">Ref. Eksternal (Opsional)</label>
            <input type="text" name="external_ref" id="external_ref" placeholder="#INV-12345"
                style="padding: 0.875rem; border-radius: 10px; border: 1px solid #d1d5db; background: #f9fafb;">
        </div>

        <button type="submit"
            style="margin-top: 1rem; padding: 1rem; border-radius: 12px; border: none; background: var(--primary-gradient); color: white; font-weight: 600; font-size: 1rem; cursor: pointer; transition: transform 0.2s;">
            Simpan Transaksi
        </button>
    </form>
</div>

<?php include __DIR__ . '/layout/footer.php'; ?>